#pragma once

#include <vector>

#include "GlInclude.h"


namespace lib_gl
{

//! OpenGL̃ReLXgL@\
class GlContextShare
{
public:
	void Clear(void)
	{
		m_ContextAry.clear();
	}

	void AddContext(HDC i_hdc, const HGLRC i_context)
	{
		m_ContextAry.push_back( std::pair<HDC,HGLRC>(i_hdc, i_context) );
	}

	void MakeShare(void)
	{
		for(size_t i = 1 ; i < m_ContextAry.size() ; ++i)
		{
			wglShareLists( GetTopContext().second , m_ContextAry[i].second );
		}
	}

	void BeginDrawTop(void)
	{
		wglMakeCurrent( GetTopContext().first , GetTopContext().second );
	}

	void EndDrawTop(void)
	{
		wglMakeCurrent( GetTopContext().first , 0 );
	}

	const std::pair<HDC,HGLRC>& GetTopContext(void) const { return m_ContextAry.front(); }
	const std::pair<HDC,HGLRC>& GetContext(int index) const { return m_ContextAry[index]; }


private:
	std::vector< std::pair<HDC,HGLRC> > m_ContextAry;
};

}
