// fvXobt@@\

#pragma once

#include "../lm/vector3.h"



namespace lib_gl
{


inline float glaGetDepthf(int x, int y)
{
	float z;
	glReadPixels(x, y, 1, 1, GL_DEPTH_COMPONENT, GL_FLOAT, &z);
	return z;
}

inline unsigned int glaGetDepthui(int x, int y)
{
	unsigned int z;
	glReadPixels(x, y, 1, 1, GL_DEPTH_COMPONENT, GL_UNSIGNED_INT, &z);
	return z;
}

inline lm::vec3f glaUnProjectExt(double x, double y, double z)
{
	GLint viewport[4];
	glGetIntegerv(GL_VIEWPORT,viewport);

	GLdouble mvMatrix[16], pjMatrix[16];
	glGetDoublev(GL_MODELVIEW_MATRIX, mvMatrix);
	glGetDoublev(GL_PROJECTION_MATRIX, pjMatrix);

	double wx, wy, wz;
	gluUnProject(x, y, z, mvMatrix, pjMatrix, viewport, &wx, &wy, &wz);

	return lm::vec3f((float)wx, (float)wy, (float)wz);
}

inline lm::vec3f glaGetDepthWorldPos(int x, int y)
{
	float z = glaGetDepthf(x, y);
	return glaUnProjectExt((double)x, (double)y, (double)z);
}


}
