/*!
  \file
  \brief 一時停止の状態

  \author Satofumi KAMIMURA

  $Id: pause_state.c 1898 2010-09-09 21:35:52Z satofumi $
*/

#include "pause_state.h"
#include "emergency_io_control.h"
#include "wheel_velocity.h"


void pause_state(run_t *run)
{
    int i;

    while (true) {
        if (!emergency_io_is_emergency()) {
            return;
        }

        // 車輪の速度をゼロになるように制御する
        for (i = 0; i < NUMBER_OF_WHEELS; ++i) {
            wheel_set_velocity(&run->wheel[i], 0);
        }
    }
}
