#include "GTitleScene.h"

#include "GStaticData.h"
#include "GPlayerManager.h"

using namespace GEnum;

GTitleScene::GTitleScene() {
}

GTitleScene::~GTitleScene() {
}

void GTitleScene::init() {
	/////
	// vC[
	for( int i = 0; i < GEnum::PLAYER_MAX_NUM; i ++ ) {
		GPlayer* player = &staticData->m_ObjectManager.m_aryPlayerList[i];

		player->setHP(player->getHPMax());

		//ԈُC
//		player->getRemoveFearCounter()->end();
//		player->getRemoveNennEkiCounter()->end();
//		player->getRemovePoisonCounter()->end();
	}


	// _ݒ
	staticData->m_CommonWork.randomPlayers( false );

	staticData->m_CommonWork.setupMap( MapType::TITLE );

	// Vbg̓vC[ɓȂ
	staticData->m_ObjectManager.m_ShotManager.m_bIsHitToPlayer = false;
}
void GTitleScene::process() {
	staticData->clearScreen(0,100,100);

	////////
	// adjust scroll
	{
		
		HPLScroller* scroller = staticData->getScrollManager()->getScroller(0);

		HPLVector shake = staticData->m_ShakeManager.m_vShake;

		staticData->m_ShakeManager.stepShake();

		HPLVector scrPoint(
			staticData->getSetting()->windowWidth / 2.f + shake.getX(),
			staticData->getSetting()->windowHeight / 2.f + shake.getY());

		bool isAdjust = true;

		// tag
		scroller->matchPoint(
			scrPoint, staticData->m_ObjectManager.m_aryPlayerList[0].getCenter(),
			isAdjust);
	}
	/////
	// ^C\
	{
		// draw blocks
		staticData->getBlockManager()->draw(staticData->getImageManager(),
			staticData->getGraphics()->getScreen(),
			staticData->getScrollManager()->getScroller(0));
	}
	// ړH
	bool isMove = getStaticData()->m_CommonWork.m_Game.isTheWorld() == false &&
		getStaticData()->m_CommonWork.m_Game.isMenu() == false &&
		getStaticData()->m_CommonWork.m_Game.isScenario() == false;

	for( int i = 0; i < GEnum::PLAYER_MAX_NUM; i ++ ) {
		GPlayer* player = &staticData->m_ObjectManager.m_aryPlayerList[i];

		// drawplayer
		player->draw(staticData->getImageManager());

		if( player->isAlive() == false ) {
			// X^[gn_ɖ߂
			player->setHP( player->getHPMax() );
			player->setAlive( true );

			
			player->setCenter( staticData->m_CommonWork.m_ObjectPlacer.getRandomPlayerPoint() );
		}
		if(isMove){
			GPlayerManager playerManager;
			if( i == staticData->m_ObjectManager.m_nPlayingIndex ) {
				HPLSDLInputManager* inputManager = staticData->getInputManager();

				///////
				// L[͂vC[ɔf
				player->updateKeyState(true, inputManager, GEnum::KeyMap::MAX_KEY);
			}
			{
				// AI
				player->updateKeyState( false, NULL, KeyMap::MAX_KEY );
				// L[Zbg
				player->resetKeyState( KeyMap::MAX_KEY );

				//playerManager.moveAI( player );

				// ֐i
				player->setKeyState( KeyMap::LEFT, true);

				if( HPLMath::nextDouble(0,100 ) < 1.0 ) {
					// ܂ɍU
					player->setKeyState( KeyMap::A + HPLMath::nextInt(0,3 ), true );
				} 
				if( HPLMath::nextDouble(0,100) < 5.f ) {
					// ܂ɃWv
					player->setKeyState( KeyMap::UP, true );
				}

			}
			////////////////////////////////////////////////////////////////////////////
			// collision check
			// fall and hit to collision
			HPLVector velocityAngle = player->getVelocityAngle();
			HPLVector center = player->getCenter();
			playerManager.collisionCheck(
				player,
				&center, &velocityAngle);
			////////////////////////////////////////////////////////////////////////////
			// input moving
			velocityAngle = player->getVelocityAngle();
			playerManager.move(
				player, &velocityAngle);
			player->setVelocityAngle(velocityAngle);
			////////////////////////////////////////////////////////////////////////////
			// attack
			velocityAngle = player->getVelocityAngle();
			center = player->getCenter();
			playerManager.attack(
				player, &center, &velocityAngle);
			player->setVelocityAngle(velocityAngle);

			// U͓Ȃ
			// UqbgmF
			//playerManager.checkHitToPlayer( player );
		}

	}

	staticData->m_ObjectManager.m_ShotManager.process( isMove );

	if( staticData->getInputManager()->isPressedNow( GEnum::KeyMap::A ) ) {
		// vC[ZNg
		staticData->getSceneManager()->setScene( GEnum::SceneType::PLAYER_SELECT );
	}

}
void GTitleScene::quit() {
	staticData->m_ObjectManager.m_ShotManager.m_bIsHitToPlayer = true;
}
