#include "GStageSelectScene.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

GStageSelectScene::GStageSelectScene() {
}

GStageSelectScene::~GStageSelectScene() {
}

static int SELECTABLE_MAP_LIST[] = {
	MapType::MAP000,
	MapType::MAP001,
	MapType::MAP003,
};
static int MAP_SEQUENCE_LIST[] = {
	Common::STAGE_SELECT_MAP_000,
	Common::STAGE_SELECT_MAP_001,
	Common::STAGE_SELECT_MAP_003,
};

void GStageSelectScene::init() {
	this->m_nMapIndex = 0;
	for( int i = 0; i < sizeof(SELECTABLE_MAP_LIST)/sizeof(SELECTABLE_MAP_LIST[0] ); i ++ ) {
		if( getStaticData()->getMapIndex() == SELECTABLE_MAP_LIST[i] ) {
			this->m_nMapIndex = SELECTABLE_MAP_LIST[i];
			break;
		}
	}

}

void GStageSelectScene::process() {
#ifdef _DXLIB
#else
	getStaticData()->clearScreen(0,150,100);
#endif


	// ^Cg
	{
		HPLSequence* lpSeq = getStaticData()->getSequence( SpriteType::COMMON, Common::STAGE_SELECT_TITLE );
		int nWidth = lpSeq->getImageInformation(0)->srcRect.getWidth();
		int nLeft = getStaticData()->getSetting()->windowWidth / 2 - nWidth / 2;
#ifdef _DXLIB
		getStaticData()->m_Basic.m_Graphics.draw(
			nLeft,0, lpSeq, 0);
#else
		HPLSDLImageTool::blitRotozoomSpriteLeftTop( nLeft, 0, 
			0, lpSeq, getStaticData()->getImageManager(), 
			getStaticData()->getGraphics()->getScreen());
#endif

	}

	const int STAGE_SELECT_SELECT_DELTA_X = -3;
	const int STAGE_SELECT_SELECT_DELTA_Y = -3;

	for( int i = 0; i < sizeof(SELECTABLE_MAP_LIST) / sizeof(SELECTABLE_MAP_LIST[0]); i ++ ) {
		int nLeft = STAGE_SELECT_LEFT + STAGE_SELECT_INTERVAL_X *  (i % STAGE_SELECT_COLUMN_PER_ROW);
		int nTop = STAGE_SELECT_TOP + STAGE_SELECT_INTERVAL_Y * (i / STAGE_SELECT_COLUMN_PER_ROW );
		HPLSequence* lpSeq = getStaticData()->getSequence( SpriteType::COMMON, MAP_SEQUENCE_LIST[i] );
#ifdef _DXLIB
		getStaticData()->m_Basic.m_Graphics.draw(
			nLeft,nTop, lpSeq );
#else
		HPLSDLImageTool::blitRotozoomSpriteLeftTop( 
			nLeft, nTop, 0, lpSeq, getStaticData()->getImageManager(), 
			getStaticData()->getGraphics()->getScreen() );
#endif
		if( i == this->m_nMapIndex ) {
			HPLSequence* lpSeq = getStaticData()->getSequence( SpriteType::COMMON, Common::STAGE_SELECT_SELECT );
#ifdef _DXLIB
			getStaticData()->m_Basic.m_Graphics.draw(
				nLeft + STAGE_SELECT_SELECT_DELTA_X, nTop + STAGE_SELECT_SELECT_DELTA_Y,
				lpSeq, 0);
#else
			HPLSDLImageTool::blitRotozoomSpriteLeftTop( 
				nLeft + STAGE_SELECT_SELECT_DELTA_X, nTop + STAGE_SELECT_SELECT_DELTA_Y, 0, lpSeq, getStaticData()->getImageManager(), 
				getStaticData()->getGraphics()->getScreen() );
#endif
		}
	}
	if( getStaticData()->getInputManager()->isPressedNow( GEnum::KeyMap::A ) ) {
		// }bv[h
		getStaticData()->m_CommonWork.setupMap( SELECTABLE_MAP_LIST[ this->m_nMapIndex ] );
		// Q[
		getStaticData()->m_CommonWork.setGameSceneType( GameSceneType::G_GAME );
		getStaticData()->getSceneManager()->setScene( GEnum::SceneType::GAME );

	}
	if( getStaticData()->getInputManager()->isPressedNow( KeyMap::RIGHT ) ) {
		// 
		this->m_nMapIndex ++;
		if( this->m_nMapIndex >= sizeof(SELECTABLE_MAP_LIST)/sizeof(SELECTABLE_MAP_LIST[0]) ) {
			this->m_nMapIndex = 0;
		}
	}
	if( getStaticData()->getInputManager()->isPressedNow( KeyMap::LEFT ) ) {
		// O
		this->m_nMapIndex --;
		if( this->m_nMapIndex < 0 ) {
			this->m_nMapIndex = sizeof(SELECTABLE_MAP_LIST)/sizeof(SELECTABLE_MAP_LIST[0]) - 1;
		}
	}
}
void GStageSelectScene::quit() {
}
