#ifndef _G_SHOT_MANAGER_
#define _G_SHOT_MANAGER_

#include <hpllib/cycle/HPLObjectManager.h>

#include "GShot.h"
#include "GShotSetting.h"

/** Vbg
  */
class GShotManager : public HPLObjectManager<GShot> {
public:
	std::map<std::string, int> m_mapLabelMap;			//! ^Cvԍɕϊ
	std::map<int, GShotSetting> m_mapShotSettingMap;	//! Vbg̐ݒ

	bool m_bIsHitToPlayer;

	// oϐ
private:
	std::map<int,int> m_mapTypeAndSequenceIDMapping;		//! ^CvV[PXID擾}bsO
	std::list<GShot*> m_Adds;							//! ǉpXg
	std::vector<float> shotPowerList;				//! Vbg_[W

	// Constructor/Destructor
public:
	GShotManager();
	virtual ~GShotManager();

	// Operations
public:
	/** ނV[PXID擾܂B
	  */
	int getSequenceID( int nType );

	/** ܂
	  */
	void process( bool bIsMove, bool bIsAI );

	/** 쐬܂B͖̂{֐ŃXgɒǉ܂B
	  */ 
	GShot* create( int nType, HPLVector& vCenter, int nParentID,
		int nFaceDirection);

	/** ړ܂B
	  */
	void algorithm( GShot* lpShot );

	/** Ώ1̂̓蔻菈
	  * @retval	ꍇtrue
	  */
	bool checkHitToOneTarget( GShot* lpShot, GPlayer* lpPlayer );

	/** Ώۂւ̂蔻s܂B
	  */
	void checkHitToTarget( GShot* lpShot );

	/**
		z[~O\͂ꍇz[~Os
	*/
	void homing( GShot* lpShot );

	/**
		@param shot ˕Ԃe
		@param isKillShot eǂ
		@param reflectPowerRate ˌ̍U͕ω
		@param parentID ˂{̂ID
	*/
	void reflect( GShot* lpShot, bool bIsKillShot,
		float fReflectPowerRate,
		int nParentID); 

private:
	/** ̒^
	  */
	GShot* createExplosion( GShot* lpShot );

	/** _[Wʎ擾
	  */
	float getShotPower(int t);

};

#endif
