#include "GSetting.h"

#include <hpllib/general/HPLString.h>
#include <hpllib/system/HPLFile.h>

GSetting::GSetting(){
	HPLProperties* prop = new HPLProperties();
	//////////////////////////////////////////////////
	// {
	prop->loadFromTextFile("data/General.txt");

	setHPLSetting(prop);

	delete prop;

	//////////////////////////////////////////////////
	// vC[ݒ
	prop = new HPLProperties();
	prop->loadFromTextFile("data/PlayerSetting.txt");
	player.walkMaxSpeed = prop->getFloat("WALK_MAX_SPEED");
	player.walkAccel = prop->getFloat("WALK_ACCEL");
	player.airMaxSpeed = prop->getFloat("AIR_MAX_SPEED");
	player.airAccel = prop->getFloat("AIR_ACCEL");
	player.jumpSpeed = prop->getFloat("JUMP_SPEED");
	player.jumpAccel = prop->getFloat("JUMP_ACCEL");
	delete prop;

	///////////////////////////
	// }bv

	prop = new HPLProperties();

	prop->loadFromTextFile("data/maps/MapSetting.txt");

	maps.stageLine = prop->getInt("STAGE_LINE");


	for(int i = 0; i < maps.stageLine; i ++){
		std::vector<int> lst;
		prop->getIntList(
			HPLString::chrToStr("STAGE0%d", i).c_str(),
			&lst, ",");
		maps.stageList.push_back(lst);
	}

	delete prop;

	// 
	std::vector<std::string> lines = HPLFile::loadStringLinesFromFile("data/maps/MapDescription.txt");
	for(int i = 0; i < (int)lines.size(); i ++)
	{
		if(HPLFile::isCommentLine(&lines[i]))
		{
			continue;
		}

		this->maps.stageDescriptionList.push_back(lines[i]);
	}

	// b
	this->zHitRange = 25.f;
	this->recognizeThreshold = 200.f;
	this->koguDeltaX = 16.f;

	////
	// \ȃACe
	// ͖
/*	maxItemNum[ItemType::MineralElement] = 50;
	maxItemNum[ItemType::EvilElement] = 10;
	maxItemNum[ItemType::Coin] = -1;
	maxItemNum[ItemType::EviFly] = -1;*/

}

GSetting::~GSetting(){
}
