#ifndef _TT_PLAYER_MANAGER_
#define _TT_PLAYER_MANAGER_

#include "GPlayer.h"

#include "GPlayerSetting.h"

#include <map>
#include <vector>

namespace GPlayerManagerConsts {
	static const float AUTO_CROUCH_HP_THRESHOLD = 0.3f;
}

class GPlayerManager{
public:
	std::map<int, GPlayerSetting> m_mapPlayerSettingMap;		//! vC[̍U̐ݒꗗ

private:
	void standToWalk(GPlayer* player, HPLVector* velocityAngle);
	void walkToStand(GPlayer* player, HPLVector* velocityAngle);
	void jump(GPlayer* player, HPLVector* velocityAngle);
	void crouch(GPlayer* player, HPLVector* velocityAngle);

	void playerJump(GPlayer* player, HPLVector* velocityAngle);
public:
	GPlayerManager();
	~GPlayerManager();
public:
	void move(GPlayer* player, HPLVector* velocityAngle);
	void collisionCheck(GPlayer* player, HPLVector* center, HPLVector* velocityAngle);

	void attack(GPlayer* player, HPLVector* center, HPLVector* velocityAngle);

	/**
		_AI
	*/
	void moveAI(GPlayer* player);

	/******
		ړiQΔщz)
	*/
	void moveOverObject(GPlayer* player, int direction);
	
	/**
		Gɑ΂s
	*/
	bool actionAgainstEnemy(GPlayer* player, GPlayer* enemy);

	/**
		isCheckFarY㉺̍傫mF邩ǂ
	*/
	bool searchFarEnemy(GPlayer* player, bool isCheckOnlyNearY,
		bool isCheckMeleeThreshold);

	/** P̂̓Gɑ΂čUΏۂƂ邩ǂf
	  * @retval		true		
	  * @retval		false		Ȃ
	  */
	bool checkEnemy( GPlayer* player, bool isCheckOnlyNearY,
		bool isCheckMeleeThreshold, GPlayer* lpEnemy );

	/**
	  */
	void checkHitToPlayer( GPlayer* lpPlayer );

	/**
	  */
	bool checkHitToOnePlayer( GPlayer* lpPlayer, GPlayer* lpTargetPlayer );

	bool isSkipToSearch( GPlayer* lpPlayer, GPlayer* lpTarget );
};

#endif
