#include "GPlayerManager.h"

#include <hpllib/action/HPLActionMoveTool.h>

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GPlayerManagerConsts;
using namespace std;
using namespace GEnum;

GSetting* getSetting() {
	return &getStaticData()->m_CommonWork.m_Setting;
}

float getZoom( GPlayer* lpPlayer ) {
	float fZoom = 1.f;
	if( lpPlayer->getType() == PlayerType::ELLIN ) {
		fZoom = 2.f;
	}
	return fZoom;
}


void movePlayer(GPlayer* player, HPLVector* velocityAngle,
				int direction)
{
	float RESIST = getSetting()->resist;

	float SPEED = getSetting()->player.walkMaxSpeed;
	float ACCEL = getSetting()->player.walkAccel;

	float fZoom = getZoom( player );
	SPEED *= fZoom;
	ACCEL *= fZoom;

	SPEED += RESIST;

	//////
	// /nőxς
	if(player->getTrigger()->getTrigger(TriggerType::ON_THE_GROUND)){
		ACCEL += RESIST;

		// nł͑MAXՁ[ɂȂ
		if( direction != 0 ) {
			velocityAngle->setX( static_cast<float>( direction ) * SPEED);
		}
		
	}else{
		SPEED = getSetting()->player.airMaxSpeed;
		ACCEL = getSetting()->player.airAccel;
		SPEED *= fZoom;
		ACCEL *= fZoom;

		ACCEL += RESIST/2;

		// 󒆂͉ړɂ
		HPLActionMoveTool::accelAndResistX(
			velocityAngle,
			HPLVector(direction * ACCEL,0),
			HPLVector(RESIST, 0),
			SPEED);
	}

}

void GPlayerManager::standToWalk(GPlayer* player, HPLVector* velocityAngle){
	// 
	int st = player->getState()->getState();


	bool right = player->isPressed(GEnum::KeyMap::RIGHT);
	bool left = player->isPressed(GEnum::KeyMap::LEFT);
	bool down = player->isPressed(GEnum::KeyMap::DOWN);


	// L[͂ɂĕς
	int faceDirection = 0;
	if( player->getState()->isAttackState() ) {

		// U͍EUȂ
	} else {
		if(right){
			faceDirection = FaceDirection::RIGHT;
		}
		if(left){
			faceDirection = FaceDirection::LEFT;
		}
	}

	{
		if(faceDirection != 0 && faceDirection != player->getFaceDirection()){
			/////
			// EL[ĕς
			// Xe[gZbg
			if(player->getState()->isAttackGunState()){
				player->changeState(StateType::STAND);
				st = player->getState()->getState();
			}
		}
		if(faceDirection != 0){
			player->setFaceDirection(faceDirection);
		}
	}

	// V[PX
	HPLSequenceState seqState = player->getSequence()->getState();

	// ڒnĂ
	bool isOnTheGround = player->getTrigger()->getTrigger(TriggerType::ON_THE_GROUND);

	// Ԃ	
	bool isReadyToWalk = player->getState()->isAttackState() == false;
		//player->getState()->isDeadState();
	


	if(player->isNoPlayerControllableState()){// && player->getState()->isDeadState() == false){
		// s\ȏ
		isReadyToWalk = false;
	}

	
	if( player->getTrigger()->getTrigger( TriggerType::ON_THE_GROUND ) ) {
		// nʂɂ
		if( down ) {
			// Ă

			// ړłȂ
			isReadyToWalk = false;
		}

		if( isReadyToWalk && player->isPressedNow(KeyMap::D) ) {
			// 
			// 'A'L[
			//		Taunt
			player->changeState(StateType::CAKE );
			isReadyToWalk = false;
		}
	}

	if( isReadyToWalk ||
		
		player->getState()->isReadyToWalkState() ||
		st == StateType::BORING ||
		st == StateType::FLYUP ||
		st == StateType::FLYDOWN )
	{
		// ړ\ȃXe[g

		// Eړ
		movePlayer(player, velocityAngle, faceDirection);

		if(isOnTheGround){
			// ڒn
			if(st != StateType::WALK && (left || right) && !down){
				// ɂȂ
				player->changeState(StateType::WALK);
			}
		}else{
			////
			// 
			// Ԃ͕ςȂ
		}
	} else if(st == StateType::CROUCH || st == StateType::BORING_CROUCH) {
		// Ⴊݏ

/*		if( down == false && player->isAutoCrouch( AUTO_CROUCH_HP_THRESHOLD, GEnum::KeyMap::A) ) {
			// ĂȂႪݏ

			///////////
			// L[ȊO̍
			//		I
			movePlayer(player, velocityAngle, faceDirection);

			// ɂȂ
			player->changeState(StateType::WALK);

		}else*/
		{
			///////
			// Aj[VI痧
			if(isOnTheGround && seqState.isFinishAnimation && !down){
				player->changeState(StateType::WALK);
			}
		}
	}else if( player->getState()->isFlyingState() ){

		/////
		// łI

		movePlayer(player, velocityAngle, faceDirection);
		

	}else if(st == StateType::ATTACK_PUNCH){

		// p`U
		// ړ\
		movePlayer(player, velocityAngle, faceDirection);

	}else if(st == StateType::ATTACK_PINEAPPLE){

		// U

		if(isOnTheGround){
			/////
			// nړs
		}else{
			/////
			// 󒆈ړ\
			movePlayer(player, velocityAngle, faceDirection);
		}


	}else if(player->getState()->isAttackGunState()){
		int wtype = player->getUsingWeaponTypeIndex();

/*		if(wtype == WeaponType::SemiAutoColt){
			if(isOnTheGround){
				//////
				// 
				//movePlayer(player, velocityAngle, faceDirection);
				// ?
				if(faceDirection != 0){
					player->changeState(StateType::WALK);
				}
			}else {
				flyMovePlayer(player, velocityAngle, faceDirection);
			}
		}else */
		/*if(true){//player->isUsingHeavyWeapon()){
			if(isOnTheGround){
				/////
				// nړs
			}else{
				/////
				// 󒆈ړ\(ƂĂȂ)
				flyMovePlayer(player, velocityAngle, faceDirection);
			}
		}else{
			if(isOnTheGround){
				/////
				// nړs
			}else{
				/////
				// 󒆈ړ\
				flyMovePlayer(player, velocityAngle, faceDirection);
			}
		}*/
	}/*else if(st == StateType::LYING || st == StateType::BORN){

		////
		// |Ă
		if(player->isBaby()){
			player->setBaby(false);
		}else{
			//  CROUCHԁiŁǍAƁBj
			player->changeState(StateType::CROUCH);
		}

	}*/
}

void GPlayerManager::jump(GPlayer* player, HPLVector* velocityAngle){

	int jumpMaxNum = 2;

	/*if(player->getType() == PlayerType::Trellama){
		jumpMaxNum = 3;
	}*/
	player->getJumpManager()->setJumpNumMax(jumpMaxNum);

	int st = player->getState()->getState();

	///////
	// XL[ŃWv
	bool sp = false;

	/*////
	// p`ApCibvA邢́AdΊȊỎΊgp̓Wv\
	*/
	if(st == StateType::ATTACK_PUNCH || st == StateType::ATTACK_PINEAPPLE){
	
		sp = true;
	}

	int wtype = player->getUsingWeaponTypeIndex();

	bool isStateTypeOK = (sp ||
		st == StateType::STAND || 
		st == StateType::BORING ||
		st == StateType::WALK ||
		st == StateType::WALK_READY ||
		st == StateType::FLYDOWN ||
		st == StateType::FLYUP ||
		st == StateType::CROUCH ||
		st == StateType::BORING_CROUCH);

	bool isJumpableOK = (player->getJumpManager()->isJumpable() || getStaticData()->m_CommonWork.m_Game.isCheat());

	bool isPressedJumpKey = player->isPressedNow(GEnum::KeyMap::UP);

	//////
	// never jump when tank
	if( isStateTypeOK && 
		isJumpableOK && 
		isPressedJumpKey )
	{

			this->playerJump(player, velocityAngle);
	}

}

void GPlayerManager::playerJump(GPlayer* player, HPLVector* velocityAngle){
	float JUMP_VELOCITY = getSetting()->player.jumpSpeed;

	velocityAngle->setY(-JUMP_VELOCITY);

	if(getStaticData()->m_CommonWork.m_Game.isCheat() == false){
		player->getJumpManager()->jump();
	}

	player->changeState(StateType::FLYUP);
}

void GPlayerManager::walkToStand(GPlayer* player, HPLVector* velocityAngle){
	//////////////////
	// sړL[bƎ~܂


	bool right = player->isPressed(GEnum::KeyMap::RIGHT);
	bool left = player->isPressed(GEnum::KeyMap::LEFT);

	int st = player->getState()->getState();
	if((st == StateType::WALK ||
		st == StateType::WALK_READY ||

		st == StateType::STAND)&&
		right == false &&
		left == false)
	{

		/*if(player->isAutoCrouch(AUTO_CROUCH_HP_THRESHOLD, GEnum::KeyMap::A)){
			/////
			// _[WԂƂႪ
			player->changeState(StateType::CROUCH);
		}else
		*/
		{
			player->changeState(StateType::STAND);
		}
	}

	//
	////////////

}

void GPlayerManager::crouch(GPlayer* player, HPLVector* velocityAngle){
	int st = player->getState()->getState();

	bool down = player->isPressed(GEnum::KeyMap::DOWN);
	///////////
	// ACtc30%ȉȂ荞
	/*if((st == StateType::STAND || st == StateType::BORING)&& player->isAutoCrouch(AUTO_CROUCH_HP_THRESHOLD, GEnum::KeyMap::A)){
			player->changeState(StateType::CROUCH);
	}else 
	*/
	if((st == StateType::STAND ||
		st == StateType::BORING ||
		st == StateType::WALK) &&

		down){
		////////
		// L[łႪ

		player->changeState(StateType::CROUCH);

	}else{
		HPLSequence* seq = player->getSequence();

		if( //player->isAutoCrouch(AUTO_CROUCH_HP_THRESHOLD, GEnum::KeyMap::A) == false &&
			(st == StateType::CROUCH || st == StateType::BORING_CROUCH) &&
			seq->getState().isFinishAnimation &&
			down == false )
		{
			//////
			// ႪݏԂŉL[𗣂
			// @オ
			player->changeState(StateType::STAND);
		}
	}
}

static bool isHittable( GPlayer* lpPlayer, float* lpfSpeed, float* lpfDamage ) {
	if( lpPlayer->getType() == PlayerType::PESERU ) {
		if( lpPlayer->getState()->getState() == StateType::ATTACK_2 ) {
			// XCfBO
			*lpfSpeed = PESERU_SLIDING_BLOW_SPEED;
			*lpfDamage = PESERU_SLIDING_DAMAGE;

			return true;
		}

	} else if( lpPlayer->getType() == PlayerType::DURANDANA ) {

		if( lpPlayer->getState()->getState() == StateType::ATTACK_GUN ) {
			// Oh^Cp[
			*lpfSpeed = DURANDANA_GRAND_TIPER_BLOW_SPEED;
			*lpfDamage = DURANDANA_GRAND_TIPER_DAMAGE;

			return true;

		} else if( lpPlayer->getState()->getState() == StateType::ATTACK_2 ) {
			// KATANA
			*lpfSpeed = DURANDANA_ATTACK_2_BLOW_SPEED;
			*lpfDamage = DURANDANA_ATTACK_2_DAMAGE;

			return true;

		}
	} 
	return false;
}

bool GPlayerManager::checkHitToOnePlayer( GPlayer* lpPlayer, GPlayer* lpTargetPlayer ) {
	if( this->isSkipToSearch( lpPlayer, lpTargetPlayer ) ) {
		return false;
	}

	// qbgΏ
	bool bIsHittable = false;


	float fSpeed = 0;
	float fDamage = 0;
	float fDummy = 0;
	if( isHittable( lpPlayer, &fSpeed, &fDamage ) ) {

		if( getStaticData()->m_CommonWork.isHit( lpPlayer, lpTargetPlayer ) == false ) {

			// ̈悪ԂĂȂ
			return false;
		}

		// GtFNg
		GEffect* lpEffect = getStaticData()->m_CommonWork.createEffect(
			Sequence::Effect::HIT,
			lpPlayer->getCenter(),
			lpTargetPlayer->getCenter(), 0, -1 );
		if( isHittable( lpTargetPlayer, &fDummy, &fDummy ) ) {
			// ł
			// ݂ɐ

			// т̑x́A_[WʂɂȂ
			getStaticData()->m_CommonWork.blowAway( lpPlayer, lpTargetPlayer, TWO_PLAYER_BOTH_BLOW_AWAY_SPEED );
			getStaticData()->m_CommonWork.blowAway( lpTargetPlayer, lpPlayer, TWO_PLAYER_BOTH_BLOW_AWAY_SPEED );

			// _[W
			getStaticData()->m_CommonWork.changeState( lpPlayer, StateType::DAMAGE );
			getStaticData()->m_CommonWork.changeState( lpTargetPlayer, StateType::DAMAGE );


		} else {
			// qbg
			getStaticData()->m_CommonWork.hitToPlayer( lpPlayer, lpTargetPlayer, fSpeed, fDamage );

		}
		return true;
	}

	return false;
}

void GPlayerManager::checkHitToPlayer( GPlayer* lpPlayer) {

	for( int i = 0; i < PLAYER_MAX_NUM; i ++ ) {
		this->checkHitToOnePlayer( lpPlayer, &getStaticData()->m_ObjectManager.m_aryPlayerList[i] );
	}

	for( list<GPlayer*>::iterator it = getStaticData()->m_ObjectManager.m_EnemyManager.getList()->begin();
		it != getStaticData()->m_ObjectManager.m_EnemyManager.getList()->end();
		it ++ )
	{
		this->checkHitToOnePlayer( lpPlayer, *it );
	}
}

