#include "GPMUndelsenAttack.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

GPMUndelsenAttack::GPMUndelsenAttack(){
}
GPMUndelsenAttack::~GPMUndelsenAttack(){
}

void GPMUndelsenAttack::setup( HPLShootingObject* lpObject ) {
	this->m_State = *lpObject->getState();
	this->m_nWeaponType = lpObject->getUsingWeaponTypeIndex();

	bool bIsPlayer = lpObject->getObjectType() == ObjectType::PLAYER;
	this->m_bIsHeavyWeapon = false;

	this->m_lpSequence = getStaticData()->m_CommonWork.getSequenceFromObject( lpObject );

	this->m_SequenceState = this->m_lpSequence->getState();

}


void GPMUndelsenAttack::attack( HPLShootingObject* lpObject, HPLShootingObject* lpTarget,
	HPLVector* lpCenter, HPLVector* lpVelocityAngle, 
	std::vector<bool>& vecCurrentKeyState, std::vector<bool>& vecPreviousKeyState )
{
	// ZbgAbv
	this->setup( lpObject );
	int nFaceDirection = lpObject->getFaceDirection();
	// 
	if( this->m_State.isAttackGunState() ) {

		if( this->m_SequenceState.isFinishAnimation ) {
			
			// V[PXZbg
			this->m_lpSequence->resetCounter();

			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else if( this->m_State.isAttackState() ) {

		// UXe[g
		if( this->m_SequenceState.isFinishAnimation ) {
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else {
		// ʏ

		if( lpObject->getState()->isReadyToAttackState() ) {
			// U\ȏ

			if( vecCurrentKeyState[ GEnum::KeyMap::A ] &&
				vecPreviousKeyState[ GEnum::KeyMap::A] == false) 
			{
				// FireBall
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK );
				// FIRE_BALL
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add(
					(nFaceDirection > 0 ? 1 : -1) * 30,
					10 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::FIRE_BALL, vecShotCenter, lpObject->getID(), nFaceDirection * -1 );
				// tɔˁB։
				lpShot->setFaceDirection( nFaceDirection ) ;

			} else if( vecCurrentKeyState[ GEnum::KeyMap::B ] &&
				vecPreviousKeyState[ GEnum::KeyMap::B ] == false)
			{
				// nዉ
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_2 );
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add(
					(lpObject->getFaceDirection() > 0 ? 1 : -1) * 100 +
					HPLMath::nextInt( - UNDELSEN_THUNDER_BOLT_RANDOM_X, UNDELSEN_THUNDER_BOLT_RANDOM_X ), 
					-300 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::THUNDER_BOLT, vecShotCenter, lpObject->getID(), lpObject->getFaceDirection() );
				lpShot->setVelocityAngle( 0, UNDELSEN_THUNDER_BOLT_SPEED_Y );

			} else if( vecCurrentKeyState[ GEnum::KeyMap::C ] &&
				vecPreviousKeyState[ GEnum::KeyMap::C] == false )
			{
				// ዉ
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_GUN );

				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add(
					(lpObject->getFaceDirection() > 0 ? 1 : -1) * 20 , 20 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::ODORO, vecShotCenter, lpObject->getID(), lpObject->getFaceDirection() );
				lpShot->setVelocityAngle( (lpObject->getFaceDirection() > 0 ? 1 : -1) * UNDELSEN_ODORO_SPEED_X,
					0 );

				// _[W킸ɑ
				((GPlayer*)lpObject)->addDamage( ODORO_DAMAGE );
			}
		}
	}
}
