#include "GPMTrellamaAttack.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

GPMTrellamaAttack::GPMTrellamaAttack(){
}
GPMTrellamaAttack::~GPMTrellamaAttack(){
}

void GPMTrellamaAttack::setup( HPLShootingObject* lpObject ) {
	this->m_State = *lpObject->getState();
	this->m_nWeaponType = lpObject->getUsingWeaponTypeIndex();

	bool bIsPlayer = lpObject->getObjectType() == ObjectType::PLAYER;
	this->m_bIsHeavyWeapon = false;

	this->m_lpSequence = getStaticData()->m_CommonWork.getSequenceFromObject( lpObject );

	this->m_SequenceState = this->m_lpSequence->getState();

}


void GPMTrellamaAttack::attack( HPLShootingObject* lpObject, HPLShootingObject* lpTarget,
	HPLVector* lpCenter, HPLVector* lpVelocityAngle, 
	std::vector<bool>& vecCurrentKeyState, std::vector<bool>& vecPreviousKeyState )
{
	// ZbgAbv
	this->setup( lpObject );

	// 
	if( this->m_State.isAttackGunState() ) {
		//if( vecCurrentKeyState[ GEnum::KeyMap::B ] || vecPreviousKeyState[ GEnum::KeyMap::B ] ) {
			// CVg[

			// FIRE_BALL
			HPLVector vecShotCenter = lpObject->getCenter();
			vecShotCenter.add(
				(lpObject->getFaceDirection() > 0 ? 1 : -1) * 30,
				10 );
			GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
				ShotType::FIRE_BALL, vecShotCenter, lpObject->getID(), lpObject->getFaceDirection() );
			lpShot->setVelocityAngle( 
				( lpObject->getFaceDirection() > 0 ? 1 : -1 ) * TRELLAMA_FIRE_BALL_SPEED,
				static_cast<float>( HPLMath::nextDouble( - TRELLAMA_FIRE_BALL_ERROR_Y, TRELLAMA_FIRE_BALL_ERROR_Y ) ) );
		//}

		if( this->m_SequenceState.isFinishAnimation ) {
			
			// V[PXZbg
			this->m_lpSequence->resetCounter();

			if( vecCurrentKeyState[ GEnum::KeyMap::B ] &&
				true )//this->m_nWeaponType == GEnum::WeaponType::Evigen::MINIGUN )
			{
				// ςȂ
				// Xe[ĝ܂
			} else {

				// Xe[g߂
				getStaticData()->m_CommonWork.rollBack( lpObject );
			}
		}
	} else if( this->m_State.isAttackState() ) {

		if( this->m_State.getState() == StateType::ATTACK ) {
			if( this->m_lpSequence->getFrameIndex() == 1 &&
				this->m_lpSequence->getStepCounter() == 0 )
			{
				// ōU

				// U
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( ( lpObject->getFaceDirection() > 0 ? 1: -1 ) * 20, 0 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::SWORD_SLASH, vecShotCenter, lpObject->getID(), lpObject->getFaceDirection() );
				lpShot->setVelocityAngle( ( lpObject->getFaceDirection() > 0 ? 1: -1 ) * TRELLAMA_SWORD_SLASH_SPEED_X, 0 );
			}
		}
		if( this->m_State.getState() == StateType::ATTACK_2 ) {
			// IveBbNuXg
			if( this->m_lpSequence->getFrameIndex() == 2 &&
				this->m_lpSequence->getStepCounter() == 0 )
			{
				// U
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( (lpObject->getFaceDirection() > 0 ? 1: -1) * 150, 0 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::BEAM, vecShotCenter, lpObject->getID(), lpObject->getFaceDirection() );
				lpShot->setVelocityAngle( 0, 0 );
			}
		}
		// UXe[g
		if( this->m_SequenceState.isFinishAnimation ) {
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else {
		// ʏ

		if( lpObject->getState()->isReadyToAttackState() ) {
			// U\ȏ

			if( vecCurrentKeyState[ GEnum::KeyMap::A ] &&
				vecPreviousKeyState[ GEnum::KeyMap::A] == false) 
			{
				// 
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK );
				
				// SwordSlash+Ռg
			} else if( vecCurrentKeyState[ GEnum::KeyMap::B ] ) {
				// CXg[
				// GUNUԂ TODO
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_GUN );

			} else if( vecCurrentKeyState[ GEnum::KeyMap::C ] && vecPreviousKeyState[ GEnum::KeyMap::C] == false ) {
				// IveBbNuXg
				// 
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_2 );
			}
		}
	}
}
