#include "GPMGardaAttack.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

GPMGardaAttack::GPMGardaAttack(){
}
GPMGardaAttack::~GPMGardaAttack(){
}

void GPMGardaAttack::setup( HPLShootingObject* lpObject ) {
	this->m_State = *lpObject->getState();
	this->m_nWeaponType = lpObject->getUsingWeaponTypeIndex();

	//bool bIsPlayer = lpObject->getObjectType() == ObjectType::PLAYER;
	this->m_bIsHeavyWeapon = false;//this->m_nWeaponType == GEnum::WeaponType::Evigen::MINIGUN;

	this->m_lpSequence = getStaticData()->m_CommonWork.getSequenceFromObject( lpObject );

	this->m_SequenceState = this->m_lpSequence->getState();

}


void GPMGardaAttack::attack( HPLShootingObject* lpObject, HPLShootingObject* lpTarget,
	HPLVector* lpCenter, HPLVector* lpVelocityAngle, 
	std::vector<bool>& vecCurrentKeyState, std::vector<bool>& vecPreviousKeyState )
{
	// ZbgAbv
	this->setup( lpObject );

	int nFaceDirection = ( lpObject->getFaceDirection() > 0 ? 1: -1 );

	// 
	if( this->m_State.isAttackGunState() ) {

		// do nothing

		if( this->m_SequenceState.isFinishAnimation ) {
			
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else if( this->m_State.isAttackState() ) {

		// isֈړ
		if( this->m_State.getState() == StateType::ATTACK ) {
			// 
			if( this->m_lpSequence->getFrameIndex() == 5 && 
				this->m_lpSequence->getStepCounter() == 0 )
			{
				// U
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( nFaceDirection * GARDA_RYUHA_1_X, 0 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::RYUHA_1, vecShotCenter, lpObject->getID(), nFaceDirection );
				lpShot->setVelocityAngle( 0 , 0 );
			}
		} /*else if( this->m_State.getState() == StateType::ATTACK_2 ) {
			// 
			if( this->m_Sequence->getFrameIndex() == 0 && 
				this->m_Sequence->getStepCounter() == 0 )
			{
			}
		}*/

		if( this->m_SequenceState.isFinishAnimation ) {
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else {
		// ʏ

		if( lpObject->getState()->isReadyToAttackState() ) {
			// U\ȏ

			if( vecCurrentKeyState[ GEnum::KeyMap::A ] && vecPreviousKeyState[ GEnum::KeyMap::A ] == false ) {
				// Z->
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK );

			} else if( vecCurrentKeyState[ GEnum::KeyMap::B ] && vecPreviousKeyState[ GEnum::KeyMap::B ] == false ) {
				// X->
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_2 );
				// U
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( 0, -GARDA_RYUHA_2_Y );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::RYUHA_2, vecShotCenter, lpObject->getID(), nFaceDirection );
				lpShot->setVelocityAngle( 0 , 0 );

			} else if( vecCurrentKeyState[ GEnum::KeyMap::C ] && vecPreviousKeyState[ GEnum::KeyMap::C ] == false ) {
				// C->]
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_GUN );
			}
		}
	}
}
