#include "GPMDurandanaAttack.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

GPMDurandanaAttack::GPMDurandanaAttack(){
}
GPMDurandanaAttack::~GPMDurandanaAttack(){
}

void GPMDurandanaAttack::setup( HPLShootingObject* lpObject ) {
	this->m_State = *lpObject->getState();
	this->m_nWeaponType = lpObject->getUsingWeaponTypeIndex();

	bool bIsPlayer = lpObject->getObjectType() == ObjectType::PLAYER;
	this->m_bIsHeavyWeapon = false;

	this->m_lpSequence = getStaticData()->m_CommonWork.getSequenceFromObject( lpObject );

	this->m_SequenceState = this->m_lpSequence->getState();

}


void GPMDurandanaAttack::attack( HPLShootingObject* lpObject, HPLShootingObject* lpTarget,
	HPLVector* lpCenter, HPLVector* lpVelocityAngle, 
	std::vector<bool>& vecCurrentKeyState, std::vector<bool>& vecPreviousKeyState )
{
	// ZbgAbv
	this->setup( lpObject );

	int nFaceDirection = lpObject->getFaceDirection();

	// 
	if( this->m_State.isAttackGunState() ) {

		// 
		lpVelocityAngle->setX( 
			( lpObject->getFaceDirection() > 0 ? 1 : -1 ) * DURANDANA_GRAND_TIPER_SPEED_X );

		if( this->m_lpSequence->getFrameIndex() >= 8 ) {
			// ㏸
			lpVelocityAngle->setY( - DURANDANA_GRAND_TIPER_SPEED_Y );
		}

		if( this->m_SequenceState.isFinishAnimation ) {
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else if( this->m_State.isAttackState() ) {

		if( this->m_State.getState() == StateType::ATTACK ) {
			if( this->m_lpSequence->getFrameIndex() == 1 &&
				this->m_lpSequence->getStepCounter() == 0 )
			{
				// ōU

				// U
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( ( lpObject->getFaceDirection() > 0 ? 1: -1 ) * 20, 0 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::ONLY_SLASH, vecShotCenter, lpObject->getID(), nFaceDirection );
				lpShot->setVelocityAngle( 0, 0 );
			}
		}
		if( this->m_State.getState() == StateType::ATTACK_2 ) {
			// KATANA
			if( this->m_lpSequence->getFrameIndex() == 3 &&
				this->m_lpSequence->getStepCounter() == 0 )
			{
				// u
				lpVelocityAngle->set( 
					( lpObject->getFaceDirection() > 0 ? 1: -1 ) * DURANDANA_ATTACK_2_SPEED_X, 0 );
			}
		}
		// UXe[g
		if( this->m_SequenceState.isFinishAnimation ) {
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else {
		// ʏ

		if( lpObject->getState()->isReadyToAttackState() ) {
			// U\ȏ

			if( vecCurrentKeyState[ GEnum::KeyMap::A ] &&
				vecPreviousKeyState[ GEnum::KeyMap::A] == false) 
			{
				// 
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK );
				
			} else if( vecCurrentKeyState[ GEnum::KeyMap::B ] &&
				vecPreviousKeyState[ GEnum::KeyMap::B] == false )
			{
				// KATANA
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_2 );

			} else if( vecCurrentKeyState[ GEnum::KeyMap::C ] &&
				vecPreviousKeyState[ GEnum::KeyMap::C] == false )
			{
				// Oh^Cp[
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_GUN );
			}
		}
	}
}
