#ifndef _G_COMMON_WORK_
#define _G_COMMON_WORK_

#include "GPlayer.h"
#include "GObjectPlacer.h"
#include "GSetting.h"
#include "GGame.h"
#include "GEffect.h"

class GCommonWork {
public:
	int					m_nWinnerForceID;			//! 
	GGame				m_Game;						//! Q[֘Af[^
	GObjectPlacer		m_ObjectPlacer;				//! IuWFNgݒu
	GSetting			m_Setting;					//!	t@Cɕۑݒ

	std::vector<int> m_vecPlayerSequenceNumbers;	//! evC[ĂV[PX

private:
	int					m_nGameSceneType;			//! Q[V[̎g܂킵^Cv

	// Constructor
public:
	GCommonWork();
	~GCommonWork();

	// Getter/Setter
public:
	//! m_nGameSceneType
	int getGameSceneType() {
		return this->m_nGameSceneType;
	}
	//! ʃV[GAMȆJڈȊOŎgpȂ
	void setGameSceneType( int nGameSceneType ) {
		this->m_nGameSceneType = nGameSceneType;
	}

	// Operations
public:
	/** ̃ZbgAbv
	  * EUASYo^
	  */
	void setup();

	/** Wv\ȏԂmFBړs
	  * @param[in]	lpoPlayer		vC[
	  * @param[in]	lpvCenter			vC[̒SW
	  * @param[in]	lpvVelocityAngle	ړƈړ
	  */
	void jumpCheck(HPLShootingObject* lpPlayer, HPLVector* lpvCenter, HPLVector* lpvVelocityAngle);

	/** }bvǂݍ
	  * @param[in]	nIndex	ǂݍރ}bvCfbNX
	  */
	void setupMap( int nIndex );

	/////////////////////////
	// ʉς
	/**
	  * ̃IuWFNg̓蔻s
	  * ʏ
	  * @param[in]	lpoObject1
	  * @param[in]	lpoObject2
	  * @retval	true	ڐG
	  */
	bool isHit( HPLShootingObject* lpoObject1, HPLShootingObject* lpoObject2 );

	/**
	  * ́ú͈vLil͈̔́j
	  * @param[in]	aMin
	  * @param[in]	aMax
	  * @param[in]	bMin
	  * @param[in]	bMax
	  * @retval	true	LL
	  */
	bool isShare(float aMin, float aMax, float bMin, float bMax);

	/** 𐁂΂
	  * @param[in]		lpoBlower		΂
	  * @param[in,out]	lpoTarget		΂鑤
	  */
	void blowAway( HPLShootingObject* lpoBlower, HPLShootingObject* lpoTarget,
		float fSpeed);
	/////////////////////////

	/** IuWFNg̎ނɂ킹changeState()Ăяo
	  * changeState()̓vWFNgŗL̂
	  * @param[in]	
	  */
	void changeState(HPLShootingObject* obj, int newState);

	/** т̃V[PXID擾
	  * @param[in]		lpoObject	Ώۂ̃IuWFNg
	  * @retval			int			V[PXID
	  */
	int getEvigenSequenceID(HPLShootingObject* lpoObject);

	/** _[WV[PXID擾
	  * @param[in]		lpoObject	Ώۂ̃IuWFNg
	  * @retval			int			V[PXID
	  */
	int getDamageSequenceID(HPLShootingObject* lpoObject);

	/**
	  * т̎莝\
	  * @param[in]	lpoEvigen		т
	  * @param[in]	lpsWeaponSprite	\pXvCg
	  * @param[in]	fLeft			т̍W
	  * @param[in]	fTop				
	  * @param[in]	bIsUp			~jKŎグĂ邩ǂ
	  */
	void drawEvigenWeapon(HPLShootingObject* lpoEvigen,
									HPLSprite* lpsWeaponSprite,
									float fLeft, float fTop,
									bool bIsUp);

	/** 󒆂ł̃_[WXe[gݒ
	  * łƌĂtŁAXe[gقȂ
	  * 
	  * @param[int,out]	obj	Ώۂ̃IuWFNg
	  */
	void setDamageFlyingState(HPLShootingObject* obj);

	/** vC[Ȃ̂GȂ̂ʂĎ擾
	  */
	HPLSequence* getSequenceFromObject( HPLShootingObject* lpObject );

	void rollBack( HPLShootingObject* lpObject );

	void drawNumbers( int nLeft, int nTop, int nNum );

	/** vC[Ƀ_[W^Đ΂܂
	  * @param[in]	lpDamageSource		eAGÃvC[
	  * @param[in]	lpTargetPlayer		_[W^Ώۂ̃vC[
	  * @param[in]	fSpeed				΂Xs[h
	  * @param[in]	fDamage				_[W
	  */
	void hitToPlayer( HPLShootingObject* lpDamageSource, GPlayer* lpTargetPlayer, float fSpeed, float fDamage );

	/** vC[̎ނ_ɂ
	  * @param[in]	bIsExceptController		삵ĂvC[ɂĂ͏O
	  */
	void randomPlayers( bool bIsExceptController );

	GEffect* createEffect(int nType,
		const HPLVector& vFrom,
		const HPLVector& vTo,
		int nCreateEnemyType, int nForceID );

	/** vC[̕\
	  * @param[in]		nPlayerType
	  * @param[in]		state
	  * @param[in,out]	m_lpEvigenWeaponSprite
	  * @param[in,out]	m_lpDurandalSprite
	  */
	void drawPlayerWeapon(GPlayer& player, int nLeft, int nTop );
/*		int nPlayerType, HPLState state,
		HPLSprite* m_lpEvigenWeaponSprite,
		HPLSprite* m_lpDurandalSprite,
		int nFaceDirection,
		int left, int top,
		int nSequenceID);*/
	HPLSequencePair* getWeaponSequencePair(GPlayer& lpPlayer);

	/** vC[̃ftHg`
	  * @param[in]		lpPlayer		Ώ
	  * @param[in]		bIsEnemy		ꂽGȂtrue
	  * @param[in]		nGameSceneType	ǂ̏ʂ̑삩
	  */
	void defaultPlayerProcess( GPlayer* lpPlayer, bool bIsEnemy );

	/** GThobÑXe[W
	  */
	bool isTestStage();

	/** g܂킵̃Q[V[
	  */
	void changeGameSceneType( int nGameSceneType );

	/** ʎYL
	  */
	bool isEnemyCreatable();
};

#endif
