package org.phosphoresce.webcore.ext.struts.util;

import java.io.Serializable;
import java.util.List;

import org.phosphoresce.lib.commons.util.ObjectUtil;
import org.phosphoresce.webcore.ext.struts.exception.StrutsProcessInternalException;

/**
 * アクションフォーム/ビーンユーティリティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/10/23	Kitagawa		全体的に再構築
 * 2013/05/28	Kitagawa		コレクションフィールドアクセスメソッドにおいて初期値インスタンスをディープコピーするように修正
 *-->
 */
public class FormBeanUtil {

	/**
	 * コンストラクタ<br>
	 */
	private FormBeanUtil() {
		super();
	}

	/**
	 * 指定されたインデックスのリスト要素を取得します。<br>
	 * 当メソッドはリストサイズが指定インデックス未満の場合は指定された初期値を用いてリストを自動で拡大します。<br>
	 * @param list リストオブジェクト
	 * @param index リスト要素インデックス
	 * @param defaultValue リスト拡張時の要素初期値
	 * @return 
	 */
	public static <E extends Serializable> E getCollectionField(List<E> list, int index, E defaultValue) {
		try {
			if (list == null) {
				throw new NullPointerException("list");
			}
			while (list.size() - 1 < index) {
				list.add((E) ObjectUtil.deepCopy(defaultValue));
			}
			return list.get(index);
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR00002", e);
		}
	}

	/**
	 * 指定されたインデックスのリスト要素を設定します。<br>
	 * 当メソッドはリストサイズが指定インデックス未満の場合は指定された初期値を用いてリストを自動で拡大します。<br>
	 * @param list リストオブジェクト
	 * @param index リスト要素インデックス
	 * @param defaultValue リスト拡張時の要素初期値
	 * @param value 設定値
	 */
	public static <E extends Serializable> void setCollectionField(List<E> list, int index, E defaultValue, E value) {
		try {
			if (list == null) {
				throw new NullPointerException("list");
			}
			while (list.size() - 1 < index) {
				list.add((E) ObjectUtil.deepCopy(defaultValue));
			}
			list.set(index, value);
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR00002", e);
		}
	}
}
