package org.phosphoresce.webcore.ext.struts.exception;

import org.phosphoresce.webcore.core.exception.WebcoreCriticalException;

/**
 * Strutsサーブレット処理関連例外クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public class StrutsProcessInternalException extends StrutsModuleCriticalException {

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param cause 例外要因
	 */
	public StrutsProcessInternalException(String code, Throwable cause) {
		super(code, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param binds 例外メッセージバインドオブジェクト
	 * @param cause 例外要因
	 */
	public StrutsProcessInternalException(String code, Object[] binds, Throwable cause) {
		super(code, binds, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 */
	public StrutsProcessInternalException(String code) {
		super(code);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 * @param binds 例外メッセージバインドオブジェクト
	 */
	public StrutsProcessInternalException(String code, Object[] binds) {
		super(code, binds);
	}
}
