package org.phosphoresce.webcore.ext.struts.exception;

import org.phosphoresce.webcore.core.exception.WebcoreApplicationException;
import org.phosphoresce.webcore.core.transaction.TransactionUser;
import org.phosphoresce.webcore.ext.struts.StrutsConstants;
import org.phosphoresce.webcore.ext.struts.action.AbstractForm;
import org.phosphoresce.webcore.ext.struts.action.ActionContext;
import org.phosphoresce.webcore.ext.struts.action.Forward;
import org.phosphoresce.webcore.ext.struts.action.MessageSet;

/**
 * Strutsアドオンモジュールアプリケーション例外クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public abstract class StrutsModuleApplicationException extends WebcoreApplicationException implements StrutsConstants, StrutsModuleException {

	/**
	 * コンストラクタ<br>
	 */
	public StrutsModuleApplicationException() {
		super();
	}

	/**
	 * アプリケーションメッセージを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return アプリケーションメッセージ
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleException#createApplicationMessage(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	public abstract <L extends TransactionUser, F extends AbstractForm<L>> MessageSet createApplicationMessage(ActionContext<L, F> actionContext);

	/**
	 * 遷移用アクションフォワードを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return 遷移用アクションフォワード
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleException#createActionForward(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	public abstract <L extends TransactionUser, F extends AbstractForm<L>> Forward createActionForward(ActionContext<L, F> actionContext);

	/**
	 * レスポンスステータスを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return レスポンスステータス(特別なステータスコードが不要であればnullを返却します)
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleException#createResponseStatus(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	public abstract <L extends TransactionUser, F extends AbstractForm<L>> Integer createResponseStatus(ActionContext<L, F> actionContext);
}
