package org.phosphoresce.webcore.ext.struts.exception;

import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.transaction.TransactionUser;
import org.phosphoresce.webcore.ext.struts.StrutsConfigNames;
import org.phosphoresce.webcore.ext.struts.action.AbstractForm;
import org.phosphoresce.webcore.ext.struts.action.ActionContext;
import org.phosphoresce.webcore.ext.struts.action.Forward;
import org.phosphoresce.webcore.ext.struts.action.MessageSet;

/**
 * 不正トークン例外クラス<br>
 * <br>
 * 当クラスはアクション処理時にトークンチェックを行い、不正なトークンでの遷移が行われた際にスローされます。<br>
 * 致命的な例外ではなくアプリケーションレベルの例外として利用されます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public class StrutsInvalidTokenException extends StrutsModuleApplicationException {

	/**
	 * コンストラクタ<br>
	 */
	public StrutsInvalidTokenException() {
		super();
	}

	/**
	 * アプリケーションメッセージを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return アプリケーションメッセージ
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException#createApplicationMessage(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends TransactionUser, F extends AbstractForm<L>> MessageSet createApplicationMessage(ActionContext<L, F> actionContext) {
		MessageSet set = null;
		if (actionContext.isJSONReuqest()) {
			set = new MessageSet("FSTR00042");
		} else if (actionContext.isPopupRequest()) {
			set = new MessageSet("FSTR00042");
		} else {
			set = new MessageSet("FSTR00042");
		}
		return set;
	}

	/**
	 * 遷移用アクションフォワードを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return 遷移用アクションフォワード
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException#createActionForward(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends TransactionUser, F extends AbstractForm<L>> Forward createActionForward(ActionContext<L, F> actionContext) {
		Forward forward = null;
		if (actionContext.isJSONReuqest()) {
			forward = null;
		} else if (actionContext.isPopupRequest()) {
			forward = new Forward();
			forward.setPath(JSP_MESSAGE_PAGE);
			forward.setRedirect(false);
		} else {
			forward = new Forward();
			forward.setPath(actionContext.getServletRequest().getServletPath() + "/" + Config.getString(StrutsConfigNames.STRUTS_ACTION_DEFAULT));
			forward.setRedirect(false);
		}
		return forward;
	}

	/**
	 * レスポンスステータスを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return レスポンスステータス(特別なステータスコードが不要であればnullを返却します)
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleApplicationException#createResponseStatus(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends TransactionUser, F extends AbstractForm<L>> Integer createResponseStatus(ActionContext<L, F> actionContext) {
		if (Config.isEmpty(StrutsConfigNames.STRUTS_STATUS_TOKENERROR)) {
			return null;
		} else {
			return Config.getInteger(StrutsConfigNames.STRUTS_STATUS_TOKENERROR);
		}
	}
}
