package org.phosphoresce.webcore.ext.struts.config;

import java.io.Serializable;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.phosphoresce.lib.commons.util.StringUtil;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.ext.struts.StrutsConfigNames;
import org.phosphoresce.webcore.ext.struts.action.AbstractForm;
import org.phosphoresce.webcore.ext.struts.enums.FormScope;
import org.phosphoresce.webcore.ext.struts.exception.StrutsProcessInternalException;
import org.phosphoresce.webcore.ext.struts.util.StrutsAnnotationUtil;
import org.phosphoresce.webcore.ext.struts.util.StrutsUtil;
import org.slf4j.LoggerFactory;

/**
 * モジュールコンフィグ拡張クラス<br>
 * <br>
 * 当クラスは標準のModuleConfigを拡張したクラスでActionの生成をstruts-config.xmlからの生成ではなく、
 * リクエストされたパスから動的に生成するように拡張されたクラスです。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/07/04	Kitagawa		全体的に再構築
 *-->
 */
public final class CustomModuleConfig extends ModuleConfigImpl {

	/** ロガーオブジェクト */
	protected CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/**
	 * コンストラクタ<br>
	 */
	public CustomModuleConfig() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param prefix プレフィックス
	 */
	public CustomModuleConfig(String prefix) {
		super(prefix);
	}

	/**
	 * 指定されたリクエストパスからActionConfigを検索して取得します。<br>
	 * @see org.apache.struts.config.impl.ModuleConfigImpl#findActionConfig(java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public ActionConfig findActionConfig(String actionPath) {
		try {
			/*
			 * サーブレットパスからアクションコンフィグを取得
			 */
			ActionConfig actionConfig = (ActionConfig) actionConfigs.get(actionPath);
			if (actionConfig == null && matcher != null) {
				actionConfig = matcher.match(actionPath);
			}

			/*
			 * サーブレットパスが未指定の場合はディフォルトアクションパスとする
			 */
			String functionId = StrutsUtil.getRequestFunction(actionPath);
			if (StringUtil.isEmpty(functionId)) {
				actionPath = Config.getString(StrutsConfigNames.STRUTS_URL_INDEX);
			}

			/*
			 * アクションコンフィグが存在しない場合はインスタンス生成
			 */
			if (actionConfig == null) {
				Class<? extends AbstractForm<? extends Serializable>> formClass = StrutsUtil.getFormClass(actionPath);
				String name = StrutsUtil.getFormClassSimpleName(actionPath);
				FormScope scope = StrutsAnnotationUtil.getFormScope(formClass);
				String className = StrutsUtil.getActionClassName(actionPath);
				actionConfig = new ActionMapping();
				actionConfig.setCancellable(false);
				actionConfig.setParameter(actionPath);
				actionConfig.setValidate(true);
				actionConfig.setName(name);
				actionConfig.setScope(scope == null ? null : scope.getValue());
				actionConfig.setType(className);
				actionConfigs.put(actionPath, actionConfig);
				log.output("FSTR00009", actionPath);
			}

			return actionConfig;
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR00008", e);
		}
	}

	/**
	 * Struts環境設定モジュールの凍結処理を行います。<br>
	 * 動的定義変更を実現するためにディフォルトStruts動作をオーバーライドさせて凍結処理は無視させます。<br>
	 * @see org.apache.struts.config.impl.ModuleConfigImpl#freeze()
	 */
	@Override
	public void freeze() {
		//super.freeze();
	}
}
