package org.phosphoresce.webcore.ext.struts.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.phosphoresce.webcore.core.transaction.TransactionManager;

/**
 * トランザクションアノテーション<br>
 * <br>
 * アクションメソッドアノテーションから利用されるアノテーションで利用するトランザクションクラスを定義します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/07/04	Kitagawa		全体的に再構築
 *-->
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.METHOD })
@Documented
public @interface StrutsTransaction {

	/** トランザクションルックアップ名 */
	public abstract String lookup();

	/** トランザクション管理クラス */
	public abstract Class<? extends TransactionManager> transactionClass();

	/** トランザクション接続定義名前空間 */
	public abstract String namespace() default "";
}
