package org.phosphoresce.webcore.ext.struts.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.phosphoresce.webcore.core.transaction.TransactionContext;
import org.phosphoresce.webcore.core.transaction.TransactionManager;
import org.phosphoresce.webcore.core.transaction.TransactionUser;

/**
 * サービスアノテーション<br>
 * <br>
 * サービスクラスに対して付与して利用しするアノテーションで、サービス処理の挙動定義を行います。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE })
@Documented
public @interface StrutsService {

	/** トランザクションユーザークラス */
	public abstract Class<? extends TransactionUser> transactionUser();

	/** トランザクションマネージャクラス */
	public abstract Class<? extends TransactionManager> transactionManager();

	/** トランザクションコンテキストクラス */
	public abstract Class<? extends TransactionContext<? extends TransactionManager, ? extends TransactionUser>> transactionContext();
}
