package org.phosphoresce.webcore.ext.struts.action;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import org.phosphoresce.webcore.core.TemporaryResource;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.ext.struts.exception.StrutsProcessInternalException;
import org.slf4j.LoggerFactory;

/**
 * テンポラリリソース出力ストリームコンテナクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/01/13	Kitagawa		新規作成
 * 2013/05/17	Kitagawa		全体的に再構築
 *-->
 */
public final class TemporaryOutputStreamContainer {

	/** ロガーオブジェクト */
	private CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/** ストリームキャッシュ */
	private Map<String, OutputStream> streams;

	/**
	 * コンストラクタ<br>
	 */
	TemporaryOutputStreamContainer() {
		super();
		streams = new HashMap<String, OutputStream>();
	}

	/**
	 * 指定されたテンポラリリソースパスの出力ストリームオブジェクトを取得します。<br>
	 * @param path テンポラリリソースパス
	 * @return 出力ストリームオブジェクト
	 */
	public OutputStream getStream(String path) {
		try {
			synchronized (streams) {
				OutputStream stream = new BufferedOutputStream(new FileOutputStream(TemporaryResource.getFile(path)));
				if (!streams.containsKey(path)) {
					streams.put(path, stream);
				}
				return stream;
			}
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR00013", new Object[] { path }, e);
		}
	}

	/**
	 * コンテナで管理されているストリームオブジェクトを全てクローズします。<br>
	 */
	public void close() {
		try {
			synchronized (streams) {
				for (String path : streams.keySet()) {
					streams.get(path).flush();
					streams.get(path).close();
				}
				streams.clear();
			}
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR00014", e);
		}
	}
}
