package org.phosphoresce.webcore.ext.struts.action;

import org.phosphoresce.webcore.core.transaction.TransactionUser;
import org.phosphoresce.webcore.ext.struts.exception.StrutsProcessInternalException;

/**
 * ロジックサーブレットコンテナクラス<br>
 * <br>
 * 当クラスはロジックレイヤで利用する為にラップされたサーブレットコンテナクラスです。<br>
 * 出力ストリーム取得等のアクションレイヤスコープのいくつかのインタフェースはロジックからの利用を制限され、メソッドを呼び出した場合に例外がスローされます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/10/03	Kitagawa		全体的に再構築
 *-->
 */
public class ServletContainerLogicWrapper<L extends TransactionUser> extends ServletContainer<L> {

	/**
	 * コンストラクタ<br>
	 * @param container サーブレットコンテナオブジェクト
	 */
	public ServletContainerLogicWrapper(ServletContainer<L> container) {
		super(container.getContext(), container.getRequest(), container.getResponse(), container.getSession(), container.getMessage(), container.getTransaction());
	}

	/**
	 * セッションを破棄します。<br>
	 * @deprecated ロジックで利用するサーブレットコンテナでの利用は禁止されています
	 * @see org.phosphoresce.webcore.ext.struts.ServletContainer#disposeSession()
	 */
	@Deprecated
	@Override
	public void disposeSession() {
		throw new StrutsProcessInternalException("FSTR04007");
	}

	/**
	 * ストリームコンテナを取得します。<br>
	 * @return ストリームコンテナ
	 * @deprecated ロジックで利用するサーブレットコンテナでの利用は禁止されています
	 * @see org.phosphoresce.webcore.ext.struts.action.ServletContainer#getStreamContainer()
	 */
	@Deprecated
	@Override
	public StreamContainer getStreamContainer() {
		throw new StrutsProcessInternalException("FSTR04007");
	}

	/**
	 * 指定されたオブジェクトをJSON形式でレスポンスします。<br>
	 * @param bean ビーンオブジェクト
	 * @deprecated ロジックで利用するサーブレットコンテナでの利用は禁止されています
	 * @see org.phosphoresce.webcore.ext.struts.ServletContainer#writeJSON(java.lang.Object)
	 */
	@Deprecated
	@Override
	public void writeJSON(Object bean) {
		throw new StrutsProcessInternalException("FSTR04007");
	}

	/**
	 * クッキー情報を設定します。<br>
	 * @param name クッキー保持名
	 * @param value クッキーオブジェクト
	 * @param expiry 有効日数
	 * @deprecated ロジックで利用するサーブレットコンテナでの利用は禁止されています
	 * @see org.phosphoresce.webcore.ext.struts.ServletContainer#setCookie(java.lang.String, java.lang.String, int)
	 */
	@Deprecated
	@Override
	public void setCookie(String name, String value, int expiry) {
		throw new StrutsProcessInternalException("FSTR04007");
	}

	/**
	 * クッキー情報を設定します。<br>
	 * @param name クッキー保持名
	 * @param value クッキーオブジェクト
	 * @deprecated ロジックで利用するサーブレットコンテナでの利用は禁止されています
	 * @see org.phosphoresce.webcore.ext.struts.ServletContainer#setCookie(java.lang.String, java.lang.String)
	 */
	@Deprecated
	@Override
	public void setCookie(String name, String value) {
		throw new StrutsProcessInternalException("FSTR04007");
	}

	/**
	 * 指定された名前のクッキーを削除します。<br>
	 * @param name クッキー保持名
	 * @deprecated ロジックで利用するサーブレットコンテナでの利用は禁止されています
	 * @see org.phosphoresce.webcore.ext.struts.ServletContainer#removeCookie(java.lang.String)
	 */
	@Deprecated
	@Override
	public void removeCookie(String name) {
		throw new StrutsProcessInternalException("FSTR04007");
	}
}
