package org.phosphoresce.webcore.ext.struts.action;

import org.phosphoresce.webcore.core.transaction.TransactionManager;

/**
 * 実際のトランザクション処理は行わないダミーのトランザクション管理クラスとして提供されます。<br>
 * <p>
 * このトランザクション管理クラスはアクションにおいてディフォルトトランザクション管理インスタンスとして設定されます。<br>
 * アクションに対するアノテーションでは、アクションで利用されるディフォルトのトランザクション指定が可能とされていますが、
 * 未指定時にはそのアクションのディフォルト挙動はトランザクションを利用しないことを意味します。<br>
 * しかし、アノテーションではトランザクションクラス指定は必須属性である為、ダミートランザクション管理クラスが利用されます。<br>
 * </p>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/05	Kitagawa		新規作成
 *-->
 */
public class DummyTransactionManager extends TransactionManager {

	/**
	 * コンストラクタ<br>
	 */
	public DummyTransactionManager() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param namespace 接続定義名前空間
	 */
	public DummyTransactionManager(String namespace) {
		super(namespace);
	}

	/**
	 * トランザクション開始処理を実行します。<br>
	 * @see org.phosphoresce.webcore.core.transaction.TransactionManager#openProcess()
	 */
	@Override
	protected void openProcess() {
	}

	/**
	 * トランザクションを終了処理を実行します。<br>
	 * @see org.phosphoresce.webcore.core.transaction.TransactionManager#closeProcess()
	 */
	@Override
	protected void closeProcess() {
	}

	/**
	 * トランザクションをコミット処理を実行します。<br>
	 * @see org.phosphoresce.webcore.core.transaction.TransactionManager#commitProcess()
	 */
	@Override
	protected void commitProcess() {
	}

	/**
	 * トランザクションをロールバック処理を実行します。<br>
	 * @see org.phosphoresce.webcore.core.transaction.TransactionManager#rollbackProcess()
	 */
	@Override
	protected void rollbackProcess() {
	}
}
