package org.phosphoresce.webcore.ext.struts.action;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;
import org.phosphoresce.webcore.core.transaction.TransactionContainer;
import org.phosphoresce.webcore.core.transaction.TransactionUser;
import org.phosphoresce.webcore.ext.struts.util.StrutsUtil;

/**
 * アクション処理情報保持クラス<br>
 * <br>
 * 当クラスはアクション処理実行中に利用する各種情報を保持するコンテキストクラスです。<br>
 * アクション処理拡張時にインタフェースシグネチャの変更が発生することを回避する為に包括的に情報を保持するクラスとして設けられました。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/07/03	Kitagawa		全体的に再構築
 *-->
 */
public final class ActionContext<L extends TransactionUser, F extends AbstractForm<L>> {

	/** アクション開始タイムスタンプ */
	private Long startTime = System.currentTimeMillis();

	/** アクションオブジェクト */
	private AbstractAction<L, F> action;

	/** アクションマッピングオブジェクト */
	private ActionMapping actionMapping;

	/** アクションフォームオブジェクト */
	private ActionForm actionForm;

	/** サーブレットコンテキストオブジェクト */
	private ServletContext servletContext;

	/** リクエストオブジェクト */
	private HttpServletRequest servletRequest;

	/** レスポンスオブジェクト */
	private HttpServletResponse servletResponse;

	/** モジュール環境オブジェクト */
	private ModuleConfig moduleConfig;

	/** サーブレットコンテナオブジェクト */
	private ServletContainer<L> servletContainer;

	/** セッションコンテナオブジェクト */
	private SessionContainer<L> sessionContainer;

	/** ウィンドウセッションコンテナオブジェクト */
	private WindowSessionContainer<L> windowSessionContainer;

	/** メッセージコンテナオブジェクト */
	private MessageContainer messageContainer;

	/** トランザクションコンテナオブジェクト */
	private TransactionContainer transactionContainer;

	/** キャスト済みフォームオブジェクト */
	private F castedForm;

	/** フォワードオブジェクト */
	private Forward forward;

	/** レスポンスステータス */
	private Integer responseStatus;

	/**
	 * コンストラクタ<br>
	 */
	ActionContext() {
		super();
	}

	/**
	 * アクションがポップアップウィンドウリクエストであるか判定します。<br>
	 * @return アクションがポップアップウィンドウリクエストである場合にtrueを返却
	 */
	public boolean isPopupRequest() {
		if (servletRequest == null || castedForm == null) {
			return false;
		}
		return StrutsUtil.isPopupRequest(servletRequest, castedForm);
	}

	/**
	 * アクションがJSONリクエストであるか判定します。<br>
	 * @return アクションがJSONリクエストである場合にtrueを返却
	 */
	public boolean isJSONReuqest() {
		if (servletRequest == null || castedForm == null) {
			return false;
		}
		return StrutsUtil.isJSONReuqest(servletRequest, castedForm);
	}

	/**
	 * リクエスト情報のウィンドウIDを取得します。<br>
	 * @return ウィンドウID
	 */
	public String getWindowId() {
		return StrutsUtil.getRequestWindowId(servletRequest, castedForm);
	}

	/**
	 * アクション開始タイムスタンプを取得します。<br>
	 * @return アクション開始タイムスタンプ
	 */
	public Long getStartTime() {
		return startTime;
	}

	/**
	 * アクション開始タイムスタンプを設定します。<br>
	 * @param startTime アクション開始タイムスタンプ
	 */
	void setStartTime(Long startTime) {
		this.startTime = startTime;
	}

	/**
	 * アクションオブジェクトを取得します。<br>
	 * @return アクションオブジェクト
	 */
	public AbstractAction<L, F> getAction() {
		return action;
	}

	/**
	 * アクションオブジェクトを設定します。<br>
	 * @param action アクションオブジェクト
	 */
	void setAction(AbstractAction<L, F> action) {
		this.action = action;
	}

	/**
	 * アクションマッピングオブジェクトを取得します。<br>
	 * @return アクションマッピングオブジェクト
	 */
	public ActionMapping getActionMapping() {
		return actionMapping;
	}

	/**
	 * アクションマッピングオブジェクトを設定します。<br>
	 * @param actionMapping アクションマッピングオブジェクト
	 */
	void setActionMapping(ActionMapping actionMapping) {
		this.actionMapping = actionMapping;
	}

	/**
	 * アクションフォームオブジェクトを取得します。<br>
	 * @return アクションフォームオブジェクト
	 */
	public ActionForm getActionForm() {
		return actionForm;
	}

	/**
	 * アクションフォームオブジェクトを設定します。<br>
	 * @param actionForm アクションフォームオブジェクト
	 */
	void setActionForm(ActionForm actionForm) {
		this.actionForm = actionForm;
	}

	/**
	 * サーブレットコンテキストオブジェクトを取得します。<br>
	 * @return サーブレットコンテキストオブジェクト
	 */
	public ServletContext getServletContext() {
		return servletContext;
	}

	/**
	 * サーブレットコンテキストオブジェクトを設定します。<br>
	 * @param servletContext サーブレットコンテキストオブジェクト
	 */
	void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	/**
	 * リクエストオブジェクトを取得します。<br>
	 * @return リクエストオブジェクト
	 */
	public HttpServletRequest getServletRequest() {
		return servletRequest;
	}

	/**
	 * リクエストオブジェクトを設定します。<br>
	 * @param servletRequest リクエストオブジェクト
	 */
	void setServletRequest(HttpServletRequest servletRequest) {
		this.servletRequest = servletRequest;
	}

	/**
	 * レスポンスオブジェクトを取得します。<br>
	 * @return レスポンスオブジェクト
	 */
	public HttpServletResponse getServletResponse() {
		return servletResponse;
	}

	/**
	 * レスポンスオブジェクトを設定します。<br>
	 * @param servletResponse レスポンスオブジェクト
	 */
	void setServletResponse(HttpServletResponse servletResponse) {
		this.servletResponse = servletResponse;
	}

	/**
	 * モジュール環境オブジェクトを取得します。<br>
	 * @return モジュール環境オブジェクト
	 */
	public ModuleConfig getModuleConfig() {
		return moduleConfig;
	}

	/**
	 * モジュール環境オブジェクトを設定します。<br>
	 * @param moduleConfig モジュール環境オブジェクト
	 */
	void setModuleConfig(ModuleConfig moduleConfig) {
		this.moduleConfig = moduleConfig;
	}

	/**
	 * サーブレットコンテナオブジェクトを取得します。<br>
	 * @return サーブレットコンテナオブジェクト
	 */
	public ServletContainer<L> getServletContainer() {
		return servletContainer;
	}

	/**
	 * サーブレットコンテナオブジェクトを設定します。<br>
	 * @param servletContainer サーブレットコンテナオブジェクト
	 */
	void setServletContainer(ServletContainer<L> servletContainer) {
		this.servletContainer = servletContainer;
	}

	/**
	 * セッションコンテナオブジェクトを取得します。<br>
	 * @return セッションコンテナオブジェクト
	 */
	public SessionContainer<L> getSessionContainer() {
		return sessionContainer;
	}

	/**
	 * セッションコンテナオブジェクトを設定します。<br>
	 * @param sessionContainer セッションコンテナオブジェクト
	 */
	void setSessionContainer(SessionContainer<L> sessionContainer) {
		this.sessionContainer = sessionContainer;
	}

	/**
	 * ウィンドウセッションコンテナオブジェクトを取得します。<br>
	 * @return ウィンドウセッションコンテナオブジェクト
	 */
	public WindowSessionContainer<L> getWindowSessionContainer() {
		return windowSessionContainer;
	}

	/**
	 * ウィンドウセッションコンテナオブジェクトを設定します。<br>
	 * @param windowSessionContainer ウィンドウセッションコンテナオブジェクト
	 */
	void setWindowSessionContainer(WindowSessionContainer<L> windowSessionContainer) {
		this.windowSessionContainer = windowSessionContainer;
	}

	/**
	 * メッセージコンテナオブジェクトを取得します。<br>
	 * @return メッセージコンテナオブジェクト
	 */
	public MessageContainer getMessageContainer() {
		return messageContainer;
	}

	/**
	 * メッセージコンテナオブジェクトを設定します。<br>
	 * @param messageContainer メッセージコンテナオブジェクト
	 */
	void setMessageContainer(MessageContainer messageContainer) {
		this.messageContainer = messageContainer;
	}

	/**
	 * トランザクションコンテナオブジェクトを取得します。<br>
	 * @return トランザクションコンテナオブジェクト
	 */
	public TransactionContainer getTransactionContainer() {
		return transactionContainer;
	}

	/**
	 * トランザクションコンテナオブジェクトを設定します。<br>
	 * @param transactionContainer トランザクションコンテナオブジェクト
	 */
	void setTransactionContainer(TransactionContainer transactionContainer) {
		this.transactionContainer = transactionContainer;
	}

	/**
	 * キャスト済みフォームオブジェクトを取得します。<br>
	 * @return キャスト済みフォームオブジェクト
	 */
	public F getCastedForm() {
		return castedForm;
	}

	/**
	 * キャスト済みフォームオブジェクトを設定します。<br>
	 * @param castedForm キャスト済みフォームオブジェクト
	 */
	void setCastedForm(F castedForm) {
		this.castedForm = castedForm;
	}

	/**
	 * フォワードオブジェクトを取得します。<br>
	 * @return フォワードオブジェクト
	 */
	public Forward getForward() {
		return forward;
	}

	/**
	 * フォワードオブジェクトを設定します。<br>
	 * @param forward フォワードオブジェクト
	 */
	void setForward(Forward forward) {
		this.forward = forward;
	}

	/**
	 * レスポンスステータスを取得します。<br>
	 * @return レスポンスステータス
	 */
	public Integer getResponseStatus() {
		return responseStatus;
	}

	/**
	 * レスポンスステータスを設定します。<br>
	 * @param responseStatus レスポンスステータス
	 */
	void setResponseStatus(Integer responseStatus) {
		this.responseStatus = responseStatus;
	}
}
