package org.phosphoresce.webcore.ext.struts.action;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.upload.MultipartRequestHandler;
import org.phosphoresce.lib.commons.util.ObjectUtil;
import org.phosphoresce.lib.commons.util.ReflectionUtil;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.core.transaction.TransactionUser;
import org.phosphoresce.webcore.ext.struts.annotation.CacheField;
import org.phosphoresce.webcore.ext.struts.annotation.ChainField;
import org.phosphoresce.webcore.ext.struts.exception.StrutsFormProcessException;
import org.phosphoresce.webcore.ext.struts.exception.StrutsProcessInternalException;
import org.slf4j.LoggerFactory;

/**
 * アクションフォーム上位抽象クラス<br>
 * <br>
 * Struts標準のActionFormクラスが拡張されたクラスで、フレームワーク側で共通制御される各種フィールド、操作が提供されます。<br>
 * 各サブアクションフォームは全てこれを継承して実装します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/07/04	Kitagawa		全体的に再構築
 * 2012/10/03	Kitagawa		キャッシュ不要なトークンID、ウィンドウIDはtansientを付与
 * 2012/11/08	Kitagawa		編集済み状態フィールド追加
 *-->
 */
public abstract class AbstractForm<L extends TransactionUser> extends ActionForm {

	/** ロガーオブジェクト */
	protected transient CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/** サーブレットコンテナオブジェクト */
	private transient ServletContainer<L> servlet;

	/** トークン値 */
	@ChainField
	private transient String controlFieldTokenId;

	/** ウィンドウID */
	@ChainField
	private transient String controlFieldWindowId;

	/** セッションID */
	@ChainField
	private transient String controlFieldSessionId;

	/** ポップアップ表示ウィンドウフラグ */
	@ChainField
	private String controlFieldPopupWindow;

	/** JSONリクエストフラグ */
	@ChainField
	private String controlFieldJsonRequest;

	/** 編集済みフラグ */
	private String controlFieldEdited;

	/** フォーカス要素ID */
	private String controlFieldFocusedId;

	/** ウィンドウスクロール位置(X) */
	@ChainField
	private String controlFieldWindowScrollX;

	/** ウィンドウスクロール位置(Y) */
	@ChainField
	private String controlFieldWindowScrollY;

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.ActionForm#getServlet()
	 */
	@Override
	@Deprecated
	public final ActionServlet getServlet() {
		return super.getServlet();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.ActionForm#setServlet(org.apache.struts.action.ActionServlet)
	 */
	@Override
	@Deprecated
	public final void setServlet(ActionServlet servlet) {
		super.setServlet(servlet);
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.ActionForm#getMultipartRequestHandler()
	 */
	@Override
	@Deprecated
	public final MultipartRequestHandler getMultipartRequestHandler() {
		return super.getMultipartRequestHandler();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.ActionForm#setMultipartRequestHandler(org.apache.struts.upload.MultipartRequestHandler)
	 */
	@Override
	@Deprecated
	public final void setMultipartRequestHandler(MultipartRequestHandler multipartRequestHandler) {
		super.setMultipartRequestHandler(multipartRequestHandler);
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.ActionForm#getServletWrapper()
	 */
	@Override
	@Deprecated
	public final ActionServletWrapper getServletWrapper() {
		return super.getServletWrapper();
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * 妥当性チェックメソッドはアクションごとに設けられたvalidateメソッドが利用されます。<br>
	 * @see org.apache.struts.action.ActionForm#validate(org.apache.struts.action.ActionMapping, javax.servlet.ServletRequest)
	 */
	@Override
	@Deprecated
	public final ActionErrors validate(ActionMapping mapping, ServletRequest request) {
		return super.validate(mapping, request);
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * 妥当性チェックメソッドはアクションごとに設けられたvalidateメソッドが利用されます。<br>
	 * @see org.apache.struts.action.ActionForm#validate(org.apache.struts.action.ActionMapping, javax.servlet.http.HttpServletRequest)
	 */
	@Override
	@Deprecated
	public final ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		return super.validate(mapping, request);
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * 別途用意されたresetメソッドを利用して下さい。<br>
	 * @see org.apache.struts.action.ActionForm#reset(org.apache.struts.action.ActionMapping, javax.servlet.ServletRequest)
	 */
	@Override
	@Deprecated
	public final void reset(ActionMapping mapping, ServletRequest request) {
		//super.reset(mapping, request);
		reset(servlet, null);
	}

	/**
	 * 当メソッドは当クラスによって隠ぺいされてます。<br>
	 * このメソッドはオーバーライドしたり、直接呼び出したりすることは想定されません。<br>
	 * @see org.apache.struts.action.ActionForm#reset(org.apache.struts.action.ActionMapping, javax.servlet.http.HttpServletRequest)
	 */
	@Override
	@Deprecated
	public final void reset(ActionMapping mapping, HttpServletRequest request) {
		//super.reset(mapping, request);
		reset(servlet, null);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessage(String code, Object... binds) {
		servlet.getMessage().addMessage(code, binds);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param code メッセージコード
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessage(String code) {
		servlet.getMessage().addMessage(code);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param row 明細行数
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessage(Integer row, String code, Object... binds) {
		servlet.getMessage().addMessage(row, code, binds);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param row 明細行数
	 * @param code メッセージコード
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessage(Integer row, String code) {
		servlet.getMessage().addMessage(row, code);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessageOnHead(String code, Object... binds) {
		servlet.getMessage().addMessageOnHead(code, binds);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param code メッセージコード
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessageOnHead(String code) {
		servlet.getMessage().addMessageOnHead(code);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param row 明細行数
	 * @param code メッセージコード
	 * @param binds バインドオブジェクト
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessageOnHead(Integer row, String code, Object... binds) {
		servlet.getMessage().addMessageOnHead(row, code, binds);
	}

	/**
	 * アプリケーションメッセージを追加します。<br>
	 * @param row 明細行数
	 * @param code メッセージコード
	 * @see org.phosphoresce.webcore.ext.struts.action.MessageContainer
	 */
	public final void addMessageOnHead(Integer row, String code) {
		servlet.getMessage().addMessageOnHead(row, code);
	}

	/**
	 * サーブレットコンテナオブジェクトを設定します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 */
	final void setServlet(ServletContainer<L> servlet) {
		this.servlet = servlet;
	}

	/**
	 * リスト形式のフィールドのGetterフィールド支援メソッドです。<br>
	 * public %Class% getXXXXXX(int index)から利用します。<br>
	 * @param list リストフィールド
	 * @param index リストインデックス
	 * @param defaultValue 初期値
	 * @return 指定インデックスの値
	 */
	protected final <E extends Serializable> E getCollectionField(List<E> list, int index, E defaultValue) {
		try {
			while (list.size() - 1 < index) {
				list.add((E) ObjectUtil.deepCopy(defaultValue));
			}
			return list.get(index);
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR08002", e);
		}
	}

	/**
	 * リスト形式のフィールドのGetterフィールド支援メソッドです。<br>
	 * public %Class% getXXXXXX(int index)から利用します。<br>
	 * @param list リストフィールド
	 * @param index リストインデックス
	 * @param defaultValue 初期値
	 * @param value 設定値
	 * @return 指定インデックスの値
	 */
	protected final <E extends Serializable> void setCollectionField(List<E> list, int index, E defaultValue, E value) {
		try {
			while (list.size() - 1 < index) {
				list.add((E) ObjectUtil.deepCopy(defaultValue));
			}
			list.set(index, value);
		} catch (Throwable e) {
			throw new StrutsProcessInternalException("FSTR08003", e);
		}
	}

	/**
	 * フォーカス要素IDをクリアします。<br>
	 */
	@SuppressWarnings("deprecation")
	public final void clearFocusedId() {
		setControlFieldFocusedId("");
	}

	/**
	 * 編集済みフラグをクリアします。<br>
	 */
	@SuppressWarnings("deprecation")
	public final void clearFieldEdited() {
		setControlFieldEdited("");
	}

	/**
	 * スクロール位置をクリアして上部に初期化します。<br>
	 */
	public final void clearWindowScroll() {
		setControlFieldWindowScrollX("0");
		setControlFieldWindowScrollY("0");
	}

	/**
	 * キャッシュフォームオブジェクトからフォームにキャッシュ対象フィールドのみを反映します。<br>
	 * @param cache キャッシュフォームオブジェクト
	 */
	void populateCacheField(AbstractForm<L> cache) {
		try {
			if (cache != null) {
				//for (Field cacheField : cache.getClass().getDeclaredFields()) {
				for (Field cacheField : ReflectionUtil.getFields(cache.getClass())) {
					cacheField.setAccessible(true);

					// CacheFieldアノテーション付与フィールドのみキャッシュから反映する
					if (cacheField.getAnnotation(CacheField.class) != null) {
						//Field field = form.getClass().getDeclaredField(cacheField.getName());
						Field field = ReflectionUtil.getField(this.getClass(), cacheField.getName());
						field.setAccessible(true);
						if (Modifier.isFinal(field.getModifiers())) {
							continue;
						}
						field.set(this, cacheField.get(cache));
					}
				}
			}
		} catch (Throwable e) {
			throw new StrutsFormProcessException("FSTR08001", e);
		}
	}

	/**
	 * キャッシュフォームオブジェクトからフォームに全てのフィールドを反映します。<br>
	 * @param cache キャッシュフォームオブジェクト
	 */
	void populateAllField(AbstractForm<L> cache) {
		try {
			if (cache != null) {
				//for (Field cacheField : cache.getClass().getDeclaredFields()) {
				for (Field cacheField : ReflectionUtil.getFields(cache.getClass())) {
					cacheField.setAccessible(true);

					// すべてのフィールドをキャッシュから反映する
					//Field field = form.getClass().getDeclaredField(cacheField.getName());
					Field field = ReflectionUtil.getField(this.getClass(), cacheField.getName());
					field.setAccessible(true);
					if (Modifier.isFinal(field.getModifiers())) {
						continue;
					}
					field.set(this, cacheField.get(cache));
				}
			}
		} catch (Throwable e) {
			throw new StrutsFormProcessException("FSTR08001", e);
		}
	}

	/**
	 * フォームオブジェクトをリセットします。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param session ウィンドウセッションオブジェクト
	 */
	public abstract void reset(ServletContainer<L> servlet, WindowSessionContainer<L> session);

	/**
	 * フォームオブジェクトを初期化します。<br>
	 * @param servlet サーブレットコンテナオブジェクト
	 * @param session ウィンドウセッションオブジェクト
	 */
	public abstract void init(ServletContainer<L> servlet, WindowSessionContainer<L> session);

	/**
	 * トークン値を取得します。<br>
	 * @return トークン値
	 */
	public final String getControlFieldTokenId() {
		return controlFieldTokenId;
	}

	/**
	 * トークン値を設定します。<br>
	 * @param controlFieldTokenId トークン値
	 * @deprecated 当メソッドはフレームワークより自動設定されるフィールドでJavaからの直接利用は許可されません。
	 */
	@Deprecated
	public final void setControlFieldTokenId(String controlFieldTokenId) {
		this.controlFieldTokenId = controlFieldTokenId;
	}

	/**
	 * ウィンドウIDを取得します。<br>
	 * @return ウィンドウID
	 */
	public final String getControlFieldWindowId() {
		return controlFieldWindowId;
	}

	/**
	 * ウィンドウIDを設定します。<br>
	 * @param controlFieldWindowId ウィンドウID
	 * @deprecated 当メソッドはフレームワークより自動設定されるフィールドでJavaからの直接利用は許可されません。
	 */
	@Deprecated
	public final void setControlFieldWindowId(String controlFieldWindowId) {
		this.controlFieldWindowId = controlFieldWindowId;
	}

	/**
	 * セッションIDを取得します。<br>
	 * @return セッションID
	 */
	public String getControlFieldSessionId() {
		return controlFieldSessionId;
	}

	/**
	 * セッションIDを設定します。<br>
	 * @param controlFieldSessionId セッションID
	 * @deprecated 当メソッドはフレームワークより自動設定されるフィールドでJavaからの直接利用は許可されません。
	 */
	@Deprecated
	public void setControlFieldSessionId(String controlFieldSessionId) {
		this.controlFieldSessionId = controlFieldSessionId;
	}

	/**
	 * ポップアップ表示ウィンドウフラグを取得します。<br>
	 * @return ポップアップ表示ウィンドウフラグ
	 */
	public final String getControlFieldPopupWindow() {
		return controlFieldPopupWindow;
	}

	/**
	 * ポップアップ表示ウィンドウフラグを設定します。<br>
	 * @param controlFieldPopupWindow ポップアップ表示ウィンドウフラグ
	 */
	@Deprecated
	public final void setControlFieldPopupWindow(String controlFieldPopupWindow) {
		this.controlFieldPopupWindow = controlFieldPopupWindow;
	}

	/**
	 * JSONリクエストフラグを取得します。<br>
	 * @return JSONリクエストフラグ
	 */
	public final String getControlFieldJsonRequest() {
		return controlFieldJsonRequest;
	}

	/**
	 * JSONリクエストフラグを設定します。<br>
	 * @param controlFieldJsonRequest JSONリクエストフラグ
	 */
	@Deprecated
	public final void setControlFieldJsonRequest(String controlFieldJsonRequest) {
		this.controlFieldJsonRequest = controlFieldJsonRequest;
	}

	/**
	 * フォーカス要素IDを取得します。<br>
	 * @return フォーカス要素ID
	 */
	public String getControlFieldFocusedId() {
		return controlFieldFocusedId;
	}

	/**
	 * フォーカス要素IDを設定します。<br>
	 * @param controlFieldFocusedId フォーカス要素ID
	 */
	@Deprecated
	public void setControlFieldFocusedId(String controlFieldFocusedId) {
		this.controlFieldFocusedId = controlFieldFocusedId;
	}

	/**
	 * ウィンドウスクロール位置(X)を取得します。<br>
	 * @return ウィンドウスクロール位置(X)
	 */
	public final String getControlFieldWindowScrollX() {
		return controlFieldWindowScrollX;
	}

	/**
	 * ウィンドウスクロール位置(X)を設定します。<br>
	 * スクロール位置の設定は基本的にフレームワークでの共通制御となります。<br>
	 * 機能仕様として明示的なスクロール位置制御仕様がない限り利用することは想定されません。<br>
	 * @param controlFieldWindowScrollX ウィンドウスクロール位置(X)
	 */
	public final void setControlFieldWindowScrollX(String controlFieldWindowScrollX) {
		this.controlFieldWindowScrollX = controlFieldWindowScrollX;
	}

	/**
	 * ウィンドウスクロール位置(Y)を取得します。<br>
	 * @return ウィンドウスクロール位置(Y)
	 */
	public final String getControlFieldWindowScrollY() {
		return controlFieldWindowScrollY;
	}

	/**
	 * ウィンドウスクロール位置(Y)を設定します。<br>
	 * スクロール位置の設定は基本的にフレームワークでの共通制御となります。<br>
	 * 機能仕様として明示的なスクロール位置制御仕様がない限り利用することは想定されません。<br>
	 * @param controlFieldWindowScrollY ウィンドウスクロール位置(Y)
	 */
	public final void setControlFieldWindowScrollY(String controlFieldWindowScrollY) {
		this.controlFieldWindowScrollY = controlFieldWindowScrollY;
	}

	/**
	 * 編集済みフラグを取得します。<br>
	 * @return 編集済みフラグ
	 */
	public final String getControlFieldEdited() {
		return controlFieldEdited;
	}

	/**
	 * 編集済みフラグを設定します。<br>
	 * @param controlFieldEdited 編集済みフラグ
	 */
	@Deprecated
	public final void setControlFieldEdited(String controlFieldEdited) {
		this.controlFieldEdited = controlFieldEdited;
	}

	/**
	 * クラス情報を文字列で提供します。<br>
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		Map<String, Object> map = new HashMap<String, Object>();
		for (Field field : getClass().getDeclaredFields()) {
			field.setAccessible(true);
			try {
				Object fieldValue = field.get(this);

				final int FILED_TRACE_MAX_LENGTH = 500;

				// 大量のリスト時にログ量が多くなることを防ぐ
				if (fieldValue != null) {
					if (fieldValue.toString().length() > FILED_TRACE_MAX_LENGTH) {
						fieldValue = fieldValue.toString().substring(0, FILED_TRACE_MAX_LENGTH - 1) + "...";
					}
				}

				map.put(field.getName(), fieldValue);
			} catch (Throwable e) {
				map.put(field.getName(), "<" + e.getMessage() + ">");
			}
		}
		return map.toString();
	}
}
