package org.phosphoresce.webcore.ext.struts;

import org.phosphoresce.lib.jod.JODSOfficeProcessManager;
import org.phosphoresce.webcore.core.exception.WebcoreConfigurationException;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.slf4j.LoggerFactory;

/**
 * Strutsアドオン環境初期化クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public class StrutsConfiguration implements StrutsConstants {

	/** ロガーオブジェクト */
	private static CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(StrutsConfiguration.class));

	/**
	 * コンストラクタ<br>
	 */
	private StrutsConfiguration() {
		super();
	}

	/**
	 * Strutsアドオンの初期化処理を行います。<br>
	 * 当初期化処理はアプリケーション共通初期化処理が完了されていることが前提となります。<br>
	 */
	public synchronized static void configure() {
		try {
			log.output("FSTR00001");

			// Strutsアドオンモジュール個別の初期化処理はなし

			log.output("FSTR00002");
		} catch (Throwable e) {
			throw new WebcoreConfigurationException("FSTR00004", e);
		}
	}

	/**
	 * Strutsアドオンの破棄処理を実行します。<br>
	 * @throws Throwable 終了処理中に予期せぬエラーが発生した場合にスローされます 
	 */
	public synchronized static void destroy() throws Throwable {
		JODSOfficeProcessManager.destroy();
		log.output("FSTR00003");
	}
}
