package org.phosphoresce.webcore.ext.struts;

import org.phosphoresce.webcore.core.ConfigName;

/**
 * Strutsアドオン環境設定定義名定数インタフェース<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public class StrutsConfigNames extends ConfigName {

	/** アクション基底パッケージ */
	public static final StrutsConfigNames STRUTS_ACTION_PACKAGE = new StrutsConfigNames("strtus.action.package");

	/** ディフォルトアクションメソッド */
	public static final StrutsConfigNames STRUTS_ACTION_DEFAULT = new StrutsConfigNames("strtus.action.method.default");

	/** 定数インタフェースクラスサフィックス */
	public static final StrutsConfigNames STRUTS_CLASS_SUFFIX_CONSTANTS = new StrutsConfigNames("strtus.class.suffix.constants");

	/** アクションクラスサフィックス */
	public static final StrutsConfigNames STRUTS_CLASS_SUFFIX_ACTION = new StrutsConfigNames("strtus.class.suffix.action");

	/** フォームクラスサフィックス */
	public static final StrutsConfigNames STRUTS_CLASS_SUFFIX_FORM = new StrutsConfigNames("strtus.class.suffix.form");

	/** ロジッククラスサフィックス */
	public static final StrutsConfigNames STRUTS_CLASS_SUFFIX_LOGIC = new StrutsConfigNames("strtus.class.suffix.logic");

	/** 画面セッションクラスサフィックス */
	public static final StrutsConfigNames STRUTS_CLASS_SUFFIX_SESSION = new StrutsConfigNames("strtus.class.suffix.session");

	/** ユーティリティクラスサフィックス */
	public static final StrutsConfigNames STRUTS_CLASS_SUFFIX_UTIL = new StrutsConfigNames("strtus.class.suffix.util");

	/** ルートアクションURL(アクション未指定時にリダイレクトするパス) */
	public static final StrutsConfigNames STRUTS_URL_INDEX = new StrutsConfigNames("struts.url.index");

	/** 機能JSPパス(基底パスからの相対パス指定) */
	public static final StrutsConfigNames STRUTS_JSP_FUNCTION = new StrutsConfigNames("strtus.jsp.function");

	/** システムエラーページパス(基底パスからの相対パス指定) */
	public static final StrutsConfigNames STRUTS_JSP_ERROR = new StrutsConfigNames("strtus.jsp.error");

	/** メッセージページパス(基底パスからの相対パス指定) */
	public static final StrutsConfigNames STRUTS_JSP_MESSAGE = new StrutsConfigNames("strtus.jsp.message");

	/** メッセージコード表示 */
	public static final StrutsConfigNames STRUTS_MESSAGE_DISPLAY_CODE = new StrutsConfigNames("strtus.message.display.code");

	/** ウィンドウセッションタイムアウト時間(ミリ秒) */
	public static final StrutsConfigNames STRUTS_SESSION_WINDOW_TIMEOUT = new StrutsConfigNames("strtus.session.window.timeout");

	/** ウィンドウセッションタイムアウトチェック間隔(ミリ秒) */
	public static final StrutsConfigNames STRTUS_SESSION_WINDOW_CHECK_INTERVAL = new StrutsConfigNames("strtus.session.window.check.interval");

	/** 個別サーバステータス送信定義(内部例外発生時) */
	public static final StrutsConfigNames STRUTS_STATUS_EXCEPTION = new StrutsConfigNames("struts.status.exception");

	/** 個別サーバステータス送信定義(セッションタイムアウトエラー時) */
	public static final StrutsConfigNames STRUTS_STATUS_SESSIONTIMEOUT = new StrutsConfigNames("struts.status.sessiontimeout");

	/** 個別サーバステータス送信定義(トークンエラー時) */
	public static final StrutsConfigNames STRUTS_STATUS_TOKENERROR = new StrutsConfigNames("struts.status.tokenerror");

	/** 個別サーバステータス送信定義(未ログインチェックエラー時) */
	public static final StrutsConfigNames STRUTS_STATUS_LOGINERROR = new StrutsConfigNames("struts.status.loginerror");

	/** 個別サーバステータス送信定義(バリデーションエラー時) */
	public static final StrutsConfigNames STRUTS_STATUS_VALIDATIONERROR = new StrutsConfigNames("struts.status.validationerror");

	/** 個別サーバステータス送信定義(アプリケーションエラーメッセージ存在時) */
	public static final StrutsConfigNames STRUTS_STATUS_MESSAGE_ERROR = new StrutsConfigNames("struts.status.message.error");

	/** 個別サーバステータス送信定義(アプリケーション警告メッセージ存在時) */
	public static final StrutsConfigNames STRUTS_MESSAGE_WARN = new StrutsConfigNames("struts.status.message.warning");

	/** 個別サーバステータス送信定義(アプリケーション情報メッセージ存在時) */
	public static final StrutsConfigNames STRUTS_MESSAGE_INFO = new StrutsConfigNames("struts.status.message.information");

	/**
	 * コンストラクタ<br>
	 * @param key プロパティキー
	 */
	protected StrutsConfigNames(String key) {
		super(key);
	}
}
