package org.phosphoresce.webcore.ext.smartlayout.taglib;

import org.phosphoresce.webcore.ext.smartlayout.model.TableListColumnModel;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.LooseTagConfig;

/**
 * テーブルリストカラムタグクラス<br>
 * <br>
 * 実際のカスタムタグ処理は上位{@link org.phosphoresce.webcore.ext.smartlayout.taglib.LooseTagAdapter}及び、
 * {@link org.phosphoresce.webcore.ext.smartlayout.taglib.LooseTag}が提供します。<br>
 * 当クラスでの処理提供は行いませんが{@link javax.servlet.jsp.tagext.Tag}インタフェースを実装した
 * 各タグごとのクラス設置が必要である為、設けられたクラスです。<br>
 * {@link org.phosphoresce.webcore.ext.smartlayout.taglib.LooseTag}を継承する各種タグクラスは必ず
 * {@link org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.LooseTagConfig}アノテーションが
 * 付与され、ここで定義されたモデルクラスでタグが管理する属性、テンプレート情報を提供します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/05	Kitagawa		新規作成
 *-->
 */
@LooseTagConfig(modelClass = TableListColumnModel.class)
public class TableListColumn extends LooseTagAdapter {

	/**
	 * コンストラクタ<br>
	 */
	public TableListColumn() {
		super();
	}
}
