package org.phosphoresce.webcore.ext.smartlayout.taglib;

/**
 * 汎用カスタムタグアダプタクラス<br>
 * <br>
 * 当クラスは各カスタムタグ毎にアトリビュートアクセッサを設けて実装することを回避する為に設けられました。<br>
 * ここで提供されるフィールドは全てのエレメント属性が保持され、同様にアクセッサも提供されます。<br>
 * すなわちこれを継承する各タグクラスはtldにて定義された属性のみが利用可能となります。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
abstract class LooseTagAdapter extends LooseTag {

	/** エレメントID */
	private String id;

	/** スタイルクラス */
	private String styleClass;

	/** タイトル */
	private String title;

	/** エレメントプロパティ */
	private String name;

	/** ラベル */
	private String label;

	/** メソッド */
	private String method;

	/** アクション */
	private String action;

	/** エレメント値 */
	private String value;

	/** エレメントデータ */
	private String data;

	/** データラベルキー */
	private String labelKey;

	/** データ値キー */
	private String valueKey;

	/** サイズ */
	private String size;

	/** 複数選択 */
	private boolean multiple;

	/** 幅 */
	private String width;

	/** 高さ */
	private String height;

	/** 最大文字数 */
	private String maxlength;

	/**
	 * コンストラクタ<br>
	 */
	public LooseTagAdapter() {
		super();
	}

	/**
	 * エレメントIDを取得します。<br>
	 * @return エレメントID
	 */
	public String getId() {
		return id;
	}

	/**
	 * エレメントIDを設定します。<br>
	 * @param id エレメントID
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * スタイルクラスを取得します。<br>
	 * @return スタイルクラス
	 */
	public String getStyleClass() {
		return styleClass;
	}

	/**
	 * スタイルクラスを設定します。<br>
	 * @param styleClass スタイルクラス
	 */
	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}

	/**
	 * エレメントプロパティを取得します。<br>
	 * @return エレメントプロパティ
	 */
	public String getName() {
		return name;
	}

	/**
	 * エレメントプロパティを設定します。<br>
	 * @param name エレメントプロパティ
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * ラベルを取得します。<br>
	 * @return ラベル
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * ラベルを設定します。<br>
	 * @param label ラベル
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * メソッドを取得します。<br>
	 * @return メソッド
	 */
	public String getMethod() {
		return method;
	}

	/**
	 * メソッドを設定します。<br>
	 * @param method メソッド
	 */
	public void setMethod(String method) {
		this.method = method;
	}

	/**
	 * アクションを取得します。<br>
	 * @return アクション
	 */
	public String getAction() {
		return action;
	}

	/**
	 * アクションを設定します。<br>
	 * @param action アクション
	 */
	public void setAction(String action) {
		this.action = action;
	}

	/**
	 * エレメント値を取得します。<br>
	 * @return エレメント値
	 */
	public String getValue() {
		return value;
	}

	/**
	 * エレメント値を設定します。<br>
	 * @param value エレメント値
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * エレメントデータを取得します。<br>
	 * @return エレメントデータ
	 */
	public String getData() {
		return data;
	}

	/**
	 * エレメントデータを設定します。<br>
	 * @param data エレメントデータ
	 */
	public void setData(String data) {
		this.data = data;
	}

	/**
	 * データラベルキーを取得します。<br>
	 * @return データラベルキー
	 */
	public String getLabelKey() {
		return labelKey;
	}

	/**
	 * データラベルキーを設定します。<br>
	 * @param labelKey データラベルキー
	 */
	public void setLabelKey(String labelKey) {
		this.labelKey = labelKey;
	}

	/**
	 * データ値キーを取得します。<br>
	 * @return データ値キー
	 */
	public String getValueKey() {
		return valueKey;
	}

	/**
	 * データ値キーを設定します。<br>
	 * @param valueKey データ値キー
	 */
	public void setValueKey(String valueKey) {
		this.valueKey = valueKey;
	}

	/**
	 * サイズを取得します。<br>
	 * @return サイズ
	 */
	public String getSize() {
		return size;
	}

	/**
	 * サイズを設定します。<br>
	 * @param size サイズ
	 */
	public void setSize(String size) {
		this.size = size;
	}

	/**
	 * 複数選択を取得します。<br>
	 * @return 複数選択
	 */
	public boolean isMultiple() {
		return multiple;
	}

	/**
	 * 複数選択を設定します。<br>
	 * @param multiple 複数選択
	 */
	public void setMultiple(boolean multiple) {
		this.multiple = multiple;
	}

	/**
	 * 幅を取得します。<br>
	 * @return 幅
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * 幅を設定します。<br>
	 * @param width 幅
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * 高さを取得します。<br>
	 * @return 高さ
	 */
	public String getHeight() {
		return height;
	}

	/**
	 * 高さを設定します。<br>
	 * @param height 高さ
	 */
	public void setHeight(String height) {
		this.height = height;
	}

	/**
	 * 最大文字数を取得します。<br>
	 * @return 最大文字数
	 */
	public String getMaxlength() {
		return maxlength;
	}

	/**
	 * 最大文字数を設定します。<br>
	 * @param maxlength 最大文字数
	 */
	public void setMaxlength(String maxlength) {
		this.maxlength = maxlength;
	}
}
