package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.exception.SmartLayoutTaglibProcessException;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * タブパネルページコンテナタグモデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
@SmartTagModelConfig(startTemplate = "TabPageS.vm", endTemplate = "TabPageE.vm")
public class TabPageModel extends AbstractModel {

	/** ラベル */
	@SmartTagAttributeField
	private String label;

	/**
	 * コンストラクタ<br>
	 */
	public TabPageModel() {
		super();
	}

	/**
	 * モデル階層妥当性をチェックします。<br>
	 * @throws Throwable 不正な階層構造の場合にスローされます
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#checkModelHierarchy()
	 */
	@Override
	protected void checkModelHierarchy() throws Throwable {
		/*
		 * 親タグがTabPanelでない場合はエラー
		 */
		if (!(getParent() instanceof TabPanelModel)) {
			throw new SmartLayoutTaglibProcessException("FSML00013", new Object[] { //
					getClass().getSimpleName(), //
							TabPanelModel.class.getSimpleName(), //
							getParent() == null ? "null" : getParent().getClass().getSimpleName(), //
					});
		}
	}

	/**
	 * 子モデルオブジェクト追加時のハンドラ処理を行います。<br>
	 * @param model 子モデルオブジェクト
	 * @see org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel#handleAddChild(org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel)
	 */
	@Override
	protected void handleAddChild(SmartTagModel model) {
	}

	/**
	 * ラベルを取得します。<br>
	 * @return ラベル
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * ラベルを設定します。<br>
	 * @param label ラベル
	 */
	public void setLabel(String label) {
		this.label = label;
	}
}
