package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * フォームタグモデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
@SmartTagModelConfig(startTemplate = "FormS.vm", endTemplate = "FormE.vm")
public class FormModel extends AbstractNamedModel {

	/** メソッド */
	@SmartTagAttributeField
	private String method;

	/** アクション */
	@SmartTagAttributeField
	private String action;

	/**
	 * コンストラクタ<br>
	 */
	public FormModel() {
		super();
	}

	/**
	 * メソッドを取得します。<br>
	 * @return メソッド
	 */
	public String getMethod() {
		return method;
	}

	/**
	 * メソッドを設定します。<br>
	 * @param method メソッド
	 */
	public void setMethod(String method) {
		this.method = method;
	}

	/**
	 * アクションを取得します。<br>
	 * @return アクション
	 */
	public String getAction() {
		return action;
	}

	/**
	 * アクションを設定します。<br>
	 * @param action アクション
	 */
	public void setAction(String action) {
		this.action = action;
	}
}
