package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * ドロップダウンタグモデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
@SmartTagModelConfig(startTemplate = "DropDownS.vm", endTemplate = "DropDownE.vm")
public class DropDownModel extends AbstractNamedModel {

	/** エレメントデータ */
	@SmartTagAttributeField
	private String data;

	/** データラベルキー */
	@SmartTagAttributeField(defaultValue = "label")
	private String labelKey;

	/** データ値キー */
	@SmartTagAttributeField(defaultValue = "value")
	private String valueKey;

	/**
	 * コンストラクタ<br>
	 */
	public DropDownModel() {
		super();
	}

	/**
	 * エレメントデータを取得します。<br>
	 * @return エレメントデータ
	 */
	public String getData() {
		return data;
	}

	/**
	 * エレメントデータを設定します。<br>
	 * @param data エレメントデータ
	 */
	public void setData(String data) {
		this.data = data;
	}

	/**
	 * データラベルキーを取得します。<br>
	 * @return データラベルキー
	 */
	public String getLabelKey() {
		return labelKey;
	}

	/**
	 * データラベルキーを設定します。<br>
	 * @param labelKey データラベルキー
	 */
	public void setLabelKey(String labelKey) {
		this.labelKey = labelKey;
	}

	/**
	 * データ値キーを取得します。<br>
	 * @return データ値キー
	 */
	public String getValueKey() {
		return valueKey;
	}

	/**
	 * データ値キーを設定します。<br>
	 * @param valueKey データ値キー
	 */
	public void setValueKey(String valueKey) {
		this.valueKey = valueKey;
	}
}
