package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;

/**
 * 共通上位モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractModel extends SmartTagModel {

	/** エレメントID */
	@SmartTagAttributeField
	private String id;

	/** スタイルクラス */
	@SmartTagAttributeField
	private String styleClass;

	/** タイトル */
	@SmartTagAttributeField
	private String title;

	/**
	 * コンストラクタ<br>
	 */
	public AbstractModel() {
		super();
	}

	/**
	 * エレメントIDを取得します。<br>
	 * @return エレメントID
	 */
	public final String getId() {
		return id;
	}

	/**
	 * エレメントIDを設定します。<br>
	 * @param id エレメントID
	 */
	public final void setId(String id) {
		this.id = id;
	}

	/**
	 * スタイルクラスを取得します。<br>
	 * @return スタイルクラス
	 */
	public final String getStyleClass() {
		return styleClass;
	}

	/**
	 * スタイルクラスを設定します。<br>
	 * @param styleClass スタイルクラス
	 */
	public final void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}

	/**
	 * タイトルを取得します。<br>
	 * @return タイトル
	 */
	public final String getTitle() {
		return title;
	}

	/**
	 * タイトルを設定します。<br>
	 * @param title タイトル
	 */
	public final void setTitle(String title) {
		this.title = title;
	}
}
