package org.phosphoresce.webcore.ext.smartlayout.model;

import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagAttributeField;
import org.phosphoresce.webcore.ext.smartlayout.taglib.annotation.SmartTagModelConfig;

/**
 * ラベル/値構成要素上位モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/03/13	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractLabelValueModel extends AbstractNamedModel {

	/** ラベル */
	@SmartTagAttributeField
	private String label;

	/** エレメント値 */
	@SmartTagAttributeField
	private String value;

	/**
	 * コンストラクタ<br>
	 */
	public AbstractLabelValueModel() {
		super();
	}

	/**
	 * ラベルを取得します。<br>
	 * @return ラベル
	 */
	public final String getLabel() {
		return label;
	}

	/**
	 * ラベルを設定します。<br>
	 * @param label ラベル
	 */
	public final void setLabel(String label) {
		this.label = label;
	}

	/**
	 * エレメント値を取得します。<br>
	 * @return エレメント値
	 */
	public final String getValue() {
		return value;
	}

	/**
	 * エレメント値を設定します。<br>
	 * @param value エレメント値
	 */
	public final void setValue(String value) {
		this.value = value;
	}
}
