package org.phosphoresce.webcore.ext.jdbc.factory;

import java.sql.Connection;

import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.ext.jdbc.JDBCConstants;
import org.slf4j.LoggerFactory;

/**
 * データベースコネクションファクトリ上位抽象クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2011/12/24	Kitagawa		新規作成
 *-->
 */
public abstract class JDBCConnectionFactory implements JDBCConstants {

	/** ロガーオブジェクト */
	private CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/** 自動コミットフラグ */
	private boolean autoCommit;

	/**
	 * コンストラクタ<br>
	 */
	private JDBCConnectionFactory() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param autoCommit 自動コミットフラグ
	 */
	protected JDBCConnectionFactory(boolean autoCommit) {
		super();
		this.autoCommit = autoCommit;
	}

	/**
	 * データベースコネクションを生成します。<br>
	 * @return データベースコネクションオブジェクト
	 * @throws Throwable 正常にデータベースコネクションが確立できなかった場合にスローされます
	 */
	public abstract Connection createConnection() throws Throwable;

	/**
	 * 自動コミットフラグを取得します。<br>
	 * @return 自動コミットフラグ
	 */
	public boolean isAutoCommit() {
		return autoCommit;
	}

	/**
	 * 自動コミットフラグを設定します。<br>
	 * @param autoCommit 自動コミットフラグ
	 */
	public void setAutoCommit(boolean autoCommit) {
		this.autoCommit = autoCommit;
	}
}
