package org.phosphoresce.webcore.ext.jasper.export;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

import org.phosphoresce.webcore.ext.jasper.exception.JasperCriticalException;

/**
 * JasperReports単ページ帳票出力クラス<br>
 * <br>
 * 単一のJasperReports定義体から帳票出力を行うクラスです。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/06	Kitagawa		新規作成
 *-->
 */
public class JasperSingleWriter extends JasperWriter {

	/** JasperReports帳票定義パス */
	private String jrxmlPath;

	/** JasperReports帳票データコンテナオブジェクト */
	private JasperContainer container;

	/**
	 * コンストラクタ<br>
	 */
	protected JasperSingleWriter() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param jrxmlPath JasperReports帳票定義パス
	 * @param container JasperReports帳票データコンテナオブジェクト
	 */
	public JasperSingleWriter(String jrxmlPath, JasperContainer container) {
		super();
		this.jrxmlPath = jrxmlPath;
		this.container = container;
	}

	/**
	 * コンパイル済みJasperReports帳票定義オブジェクトを生成します。<br>
	 * @return JasperReports帳票定義オブジェクト
	 * @throws JRException 正常にJasperReports帳票定義オブジェクトを生成できなかった場合にスローされます
	 */
	private JasperReport createJasperReport() throws JRException {
		if (jrxmlPath.endsWith(".jasper")) {
			return null;
		}
		return JasperCompileManager.compileReport(jrxmlPath);
	}

	/**
	 * JasperReportsデータソースオブジェクトを生成します。<br>
	 * @return JasperReportsデータソースオブジェクト
	 */
	private JRDataSource createJRDataSource() {
		return new JRBeanCollectionDataSource(container.getRecords());
	}

	/**
	 * JasperReports出力オブジェクトを生成します。<br>
	 * @return JasperReports出力オブジェクト
	 * @throws JRException 正常にJasperReports出力オブジェクトを生成できなかった場	合にスローされます
	 */
	private JasperPrint createJasperPrint() throws JRException {
		JasperReport report = createJasperReport();
		if (report == null) {
			return JasperFillManager.fillReport(jrxmlPath, container.getParameters(), createJRDataSource());
		} else {
			return JasperFillManager.fillReport(report, container.getParameters(), createJRDataSource());
		}
	}

	/**
	 * 自身が保持しているパラメータオブジェクトを指定されたJRExporterに対して設定します。<br>
	 * @param exporter JRExporterオブジェクト
	 */
	protected void fillParameter(JRExporter exporter) {
		try {
			JasperPrint print = createJasperPrint();
			exporter.setParameter(JRExporterParameter.JASPER_PRINT, print);
		} catch (Throwable e) {
			throw new JasperCriticalException("FJPR00009", e);
		}
	}
}
