package org.phosphoresce.webcore.ext.jasper.export;

import java.io.Serializable;

import org.phosphoresce.webcore.ext.jasper.JasperConstants;
import org.phosphoresce.webcore.ext.jasper.exception.JasperCriticalException;

/**
 * JasperReports出力タイプ定義クラス。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2007/11/26	Kitagawa		新規作成
 *-->
 */
public final class JasperExportType implements Serializable, JasperConstants {

	/** 出力タイプ名(PDF) */
	public static final String PDF_NAME = "PDF";

	/** 出力タイプ(PDF) */
	public static final JasperExportType PDF;

	/** 出力タイプ名(XML) */
	public static final String XML_NAME = "XML";

	/** 出力タイプ(XML) */
	public static final JasperExportType XML;

	/** 出力タイプ名(CSV) */
	public static final String CSV_NAME = "CSV";

	/** 出力タイプ(CSV) */
	public static final JasperExportType CSV;

	/** 出力タイプ名(HTML) */
	public static final String HTML_NAME = "HTML";

	/** 出力タイプ(HTML) */
	public static final JasperExportType HTML;

	/** 出力タイプ名(RTF) */
	public static final String RTF_NAME = "RTF";

	/** 出力タイプ(RTF) */
	public static final JasperExportType RTF;

	/** 出力タイプ名(ODF) */
	public static final String ODF_NAME = "ODF";

	/** 出力タイプ(ODF) */
	public static final JasperExportType ODF;

	/** 出力タイプ名(XLS[JExcelAPI]) */
	public static final String JXL_NAME = "JXL";

	/** 出力タイプ(XLS[JExcelAPI]) */
	public static final JasperExportType JXL;

	/** 出力タイプ名(XLS[POI]) */
	public static final String POI_NAME = "POI";

	/** 出力タイプ(XLS[POI]) */
	public static final JasperExportType POI;

	/** 出力タイプ名(PrintService) */
	public static final String PRINT_NAME = "PRINT";

	/** 出力タイプ(PrintService) */
	public static final JasperExportType PRINT;

	/** 出力タイプ */
	private int type;

	/** 出力タイプ名 */
	private String name;

	/** 拡張子 */
	private String extension;

	/**
	 * イニシャライザ<br>
	 */
	static {
		// ファイル出力
		PDF = new JasperExportType(0, PDF_NAME, ".pdf");
		XML = new JasperExportType(1, XML_NAME, ".xml");
		CSV = new JasperExportType(2, CSV_NAME, ".csv");
		HTML = new JasperExportType(3, HTML_NAME, ".html");
		RTF = new JasperExportType(4, RTF_NAME, ".rtf");
		ODF = new JasperExportType(5, ODF_NAME, ".odf");
		JXL = new JasperExportType(6, JXL_NAME, ".xls");
		POI = new JasperExportType(7, POI_NAME, ".xls");
		// その他
		PRINT = new JasperExportType(100, PRINT_NAME, null);
	}

	/**
	 * コンストラクタ<br>
	 */
	private JasperExportType() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param type 出力タイプ
	 * @param name 出力タイプ名
	 * @param extension 出力ファイル拡張子
	 */
	private JasperExportType(int type, String name, String extension) {
		super();
		this.type = type;
		this.name = name;
		this.extension = extension;
	}

	/**
	 * 指定された出力タイプ名を出力タイプオブジェクトに変換して提供します。<br>
	 * @param name 出力タイプ名
	 * @return 出力タイプオブジェクト
	 */
	public static JasperExportType parse(String name) {
		if (PDF_NAME.equals(name)) {
			return PDF;
		} else if (XML_NAME.equals(name)) {
			return XML;
		} else if (CSV_NAME.equals(name)) {
			return CSV;
		} else if (HTML_NAME.equals(name)) {
			return HTML;
		} else if (RTF_NAME.equals(name)) {
			return RTF;
		} else if (ODF_NAME.equals(name)) {
			return ODF;
		} else if (JXL_NAME.equals(name)) {
			return JXL;
		} else if (POI_NAME.equals(name)) {
			return POI;
		} else if (PRINT_NAME.equals(name)) {
			return PRINT;
		} else {
			throw new JasperCriticalException("FJPR00007", new String[] { name });
		}
	}

	/**
	 * 指定されたファイル名を出力タイプに合致するファイル名として提供します。<br>
	 * @param filename 対象ファイル名
	 * @return 出力タイプに合致するファイル名
	 */
	public String validateFilename(String filename) {
		if (filename.toLowerCase().endsWith(extension.toLowerCase())) {
			return filename;
		} else {
			return filename + extension.toLowerCase();
		}
	}

	/**
	 * Tオブジェクトハッシュコードを算出します。<br>
	 * @return Tオブジェクトハッシュコード
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + type;
		return result;
	}

	/**
	 * オブジェクトの比較を行います。<br>
	 * @param object 比較対象オブジェクト
	 * @return 同値のオブジェクトの場合にtrueを返却
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if (object == null) {
			return false;
		}
		if (getClass() != object.getClass()) {
			return false;
		}
		final JasperExportType other = (JasperExportType) object;
		if (type != other.type) {
			return false;
		}
		return true;
	}

	/**
	 * クラスを文字列表現で取得します。<br>
	 * @return 文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return name;
	}
}
