package org.phosphoresce.webcore.ext.jasper.export;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * JasperReports帳票データコンテナクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/06	Kitagawa		新規作成
 *-->
 */
public class JasperContainer implements Serializable {

	/** パラメータマップオブジェクト */
	private Map<String, Object> parameter;

	/** データソースリストオブジェクト */
	private List<Map<String, Object>> datasource;

	/**
	 * コンストラクタ<br>
	 */
	public JasperContainer() {
		super();
		this.parameter = new HashMap<String, Object>();
		this.datasource = new LinkedList<Map<String, Object>>();
	}

	/**
	 * パラメータを追加します。<br>
	 * @param key パラメータキー
	 * @param value パラメータ値
	 */
	public void setParameter(String key, Object value) {
		parameter.put(key, value);
	}

	/**
	 * パラメータを追加します。<br>
	 * @param map パラメータマップ
	 */
	public void setParameters(Map<String, Object> map) {
		if (map == null) {
			return;
		}
		parameter.putAll(map);
	}

	/**
	 * パラメータを取得します。<br>
	 * @param key パラメータキー
	 * @return パラメータ値
	 */
	public Object getParameter(String key) {
		return parameter.get(key);
	}

	/**
	 * パラメータを削除します。<br>
	 * @param key パラメータキー
	 */
	public void removeParameter(String key) {
		parameter.remove(key);
	}

	/**
	 * パラメータを全て削除します。<br>
	 */
	public void clearParamater() {
		parameter.clear();
	}

	/**
	 * データソースレコードを追加します。<br>
	 * @param record データソースレコード
	 */
	public void addRecord(Map<String, Object> record) {
		datasource.add(record);
	}

	/**
	 * データソースレコードを追加します。<br>
	 * @param records データソースレコードリスト
	 */
	public void addRecords(List<Map<String, Object>> records) {
		if (records == null) {
			return;
		}
		datasource.addAll(records);
	}

	/**
	 * データソースレコードを全て削除します。<br>
	 */
	public void clearRecord() {
		datasource.clear();
	}

	/**
	 * パラメータマップオブジェクトを取得します。<br>
	 * @return パラメータマップオブジェクト
	 */
	public Map<String, Object> getParameters() {
		return parameter;
	}

	/**
	 * データソースレコードリストオブジェクトを取得します。<br>
	 * @return データソースレコードリストオブジェクト
	 */
	public List<Map<String, Object>> getRecords() {
		return datasource;
	}

	/**
	 * データソースレコード件数を取得します。<br>
	 * @return データソースレコード件数
	 */
	public int getRecordCount() {
		return datasource.size();
	}
}
