package org.phosphoresce.webcore.ext.hibernate4.transaction;

import java.util.Date;

import org.phosphoresce.webcore.core.transaction.TransactionContext;
import org.phosphoresce.webcore.ext.hibernate4.model.SUser;

/**
 * Hibernateトランザクション処理コンテキストクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
public class HibernateTransactionContext<U extends SUser> extends TransactionContext<HibernateTransactionManager, U> {

	/** トランザクション名前空間 */
	private String namespace;

	/**
	 * コンストラクタ<br>
	 * @param transaction トランザクション管理オブジェクト
	 * @param processUser 処理ユーザ
	 * @param processDate 処理時刻
	 */
	public HibernateTransactionContext(HibernateTransactionManager transaction, U processUser, Date processDate) {
		super(transaction, processUser, processDate);
		this.namespace = namespace;
	}
}
