package org.phosphoresce.webcore.ext.hibernate4.transaction;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * データベースアクセスオブジェクトユーティリティ<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
class DAOUtil {

	/**
	 * コンストラクタ<br>
	 */
	private DAOUtil() {
		super();
	}

	/**
	 * データベース処理で扱う最小の日付オブジェクトを取得します。<br>
	 * @return 日付オブジェクト
	 */
	public static Date getMinimumDate() {
		try {
			return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").parse("1900/01/01 00:00:00.000");
		} catch (ParseException e) {
			return new Date(0);
		}
	}

	/**
	 * データベース処理で扱う最大の日付オブジェクトを取得します。<br>
	 * @return 日付オブジェクト
	 */
	public static Date getMaximumDate() {
		try {
			return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").parse("9999/12/31 23:59:59.999");
		} catch (ParseException e) {
			return new Date(0);
		}
	}
}
