package org.phosphoresce.webcore.ext.hibernate4.transaction;

import java.lang.reflect.Constructor;

import org.hibernate.PessimisticLockException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.exception.ConstraintViolationException;
import org.phosphoresce.webcore.ext.hibernate4.exception.HibernateEntityDuplicateException;
import org.phosphoresce.webcore.ext.hibernate4.exception.HibernateEntityLockException;
import org.phosphoresce.webcore.ext.hibernate4.exception.HibernateLogicException;
import org.phosphoresce.webcore.ext.hibernate4.exception.HibernateTransactionException;
import org.phosphoresce.webcore.ext.hibernate4.model.SUser;

/**
 * 業務ロジック上位抽象クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractHibernateLogic<U extends SUser> {

	/** 処理コンテナオブジェクト */
	private HibernateTransactionContext<U> context;

	/**
	 * コンストラクタ<br>
	 * @param context 処理コンテナオブジェクト
	 */
	protected AbstractHibernateLogic(HibernateTransactionContext<U> process) {
		super();
		this.context = process;
	}

	/**
	 * ビジネスロジック処理を実行します。<br>
	 */
	public final void execute() {
		try {
			HibernateTransactionManager transaction = context.getTransaction();
			transaction.open();

			process();

			transaction.commit();
			transaction.close();
		} catch (LockingStrategyException e) {
			throw new HibernateEntityLockException("FHBN00008", e);
		} catch (PessimisticLockException e) {
			throw new HibernateEntityLockException("FHBN00008", e);
		} catch (StaleObjectStateException e) {
			throw new HibernateEntityLockException("FHBN00009", e);
		} catch (ConstraintViolationException e) {
			throw new HibernateEntityDuplicateException("FHBN00010", e);
		} catch (Throwable e) {
			throw new HibernateLogicException("FHBN00022", e);
		}
	}

	/**
	 * ビジネスロジック処理を実行します。<br>
	 * @throws  Throwable ビジネスロジック処理中に予期せぬ例外が発生した場合にスローされます
	 */
	protected abstract void process() throws Throwable;

	/**
	 * サービスクラスインスタンスを生成します。<br>
	 * @param clazz サービスクラス
	 * @return クラスインスタンス
	 */
	protected <S extends AbstractHibernateService<U>> S createService(Class<S> clazz) {
		try {
			Constructor<S> constructor = clazz.getConstructor(new Class[] { HibernateTransactionContext.class });
			constructor.setAccessible(false);
			S instance = constructor.newInstance(new Object[] { context });
			return instance;
		} catch (Throwable e) {
			throw new HibernateTransactionException("FHBN00011", e);
		}
	}
}
