package org.phosphoresce.webcore.ext.hibernate4.transaction;

import static org.hibernate.criterion.Restrictions.*;

import java.util.LinkedList;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;

/**
 * データベースアクセス上位抽象クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractHibernateDAO<E extends AbstractHibernateEntity> {

	/** エンティティカラム名(削除ユーザ) */
	public static final String COLUMN_DELETE_USER = "deleteUser";

	/** トランザクション管理オブジェクト */
	private HibernateTransactionManager transaction;

	/**
	 * コンストラクタ<br>
	 * @param transaction トランザクション管理オブジェクト
	 */
	protected AbstractHibernateDAO(HibernateTransactionManager transaction) {
		if (transaction == null) {
			throw new NullPointerException();
		}
		this.transaction = transaction;
	}

	/**
	 * データベースアクセスクラスが扱うエンティティクラスを取得します。<br>
	 * @return 対象エンティティクラス
	 */
	protected abstract Class<E> getTargetEntityClass();

	/**
	 * データベースクエリ条件オブジェクトを生成します。<br>
	 * @return データベースクエリ条件オブジェクト
	 */
	protected GenericCriteria<E> createCriteria() {
		Criteria criteria = transaction.getSession().createCriteria(getTargetEntityClass());
		return new GenericCriteria<E>(criteria);
	}

	/**
	 * データベースクエリ条件オブジェクトを生成します。<br>
	 * @return データベースクエリ条件オブジェクト
	 */
	protected GenericCriteria<E> createCriteriaExcludeDeleted() {
		GenericCriteria<E> criteria = createCriteria();
		criteria.add(isNull(COLUMN_DELETE_USER));
		return criteria;
	}

	/**
	 * 指定されたレコードIDでエンティティを検索します。<br>
	 * @param id レコードID
	 * @return エンティティオブジェクト
	 */
	public E findById(Integer id) {
		GenericCriteria<E> criteria = createCriteria();
		criteria.add(idEq(id));
		return criteria.uniqueResult();
	}

	/**
	 * 指定されたレコードIDでエンティティを検索します。<br>
	 * @param ids レコードID
	 * @return エンティティオブジェクト
	 */
	public List<E> findById(List<Integer> ids) {
		GenericCriteria<E> criteria = createCriteria();

		List<Criterion> idOr = new LinkedList<Criterion>();
		if (ids != null) {
			for (Integer id : ids) {
				idOr.add(idEq(id));
			}
		}

		criteria.add(or(idOr.toArray(new Criterion[0])));

		return criteria.list();
	}
}
