package org.phosphoresce.webcore.ext.hibernate4.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.phosphoresce.webcore.ext.hibernate4.transaction.AbstractHibernateExpirableEntity;

/**
 * システムコードマスタエンティティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/01	Kitagawa		新規作成
 *-->
 */
@Entity
@Table(name = "s_code", //
uniqueConstraints = { //
@UniqueConstraint(columnNames = { "delete_date", "category", "code" }) //
})
public class SCode extends AbstractHibernateExpirableEntity {

	/** カテゴリ */
	@Column(name = "category", nullable = false, length = 10)
	private String category = null;

	/** コード */
	@Column(name = "code", nullable = false, length = 10)
	private String code = null;

	/** ソート順 */
	@Column(name = "order_no", nullable = false)
	private Integer orderNo = null;

	/** 名称 */
	@Column(name = "caption", nullable = false, length = 50)
	private String caption = null;

	/** 略称 */
	@Column(name = "short_caption", nullable = false, length = 50)
	private String shortCaption = null;

	/** 定義値1 */
	@Column(name = "definition_1", nullable = true, length = 50)
	private String definition1 = null;

	/** 定義値2 */
	@Column(name = "definition_2", nullable = true, length = 50)
	private String definition2 = null;

	/** 定義値3 */
	@Column(name = "definition_3", nullable = true, length = 50)
	private String definition3 = null;

	/** 定義値4 */
	@Column(name = "definition_4", nullable = true, length = 50)
	private String definition4 = null;

	/** 定義値5 */
	@Column(name = "definition_5", nullable = true, length = 50)
	private String definition5 = null;

	/** 定義値6 */
	@Column(name = "definition_6", nullable = true, length = 50)
	private String definition6 = null;

	/** 定義値7 */
	@Column(name = "definition_7", nullable = true, length = 50)
	private String definition7 = null;

	/** 定義値8 */
	@Column(name = "definition_8", nullable = true, length = 50)
	private String definition8 = null;

	/** 定義値9 */
	@Column(name = "definition_9", nullable = true, length = 50)
	private String definition9 = null;

	/**
	 * データベース登録処理前のエンティティ内容の整合処理を実施します。<br>
	 * 当処理はエンティティ毎に処理が異なります。<br>
	 * @see org.phosphoresce.webcore.ext.hibernate4.transaction.AbstractHibernateEntity#validateEntity()
	 */
	@Override
	protected void validateEntity() {
	}

	/**
	 * カテゴリを取得します。<br>
	 * @return カテゴリ
	 */
	public final String getCategory() {
		return category;
	}

	/**
	 * カテゴリを設定します。<br>
	 * @param category カテゴリ
	 */
	public final void setCategory(String category) {
		this.category = category;
	}

	/**
	 * コードを取得します。<br>
	 * @return コード
	 */
	public final String getCode() {
		return code;
	}

	/**
	 * コードを設定します。<br>
	 * @param code コード
	 */
	public final void setCode(String code) {
		this.code = code;
	}

	/**
	 * ソート順を取得します。<br>
	 * @return ソート順
	 */
	public final Integer getOrderNo() {
		return orderNo;
	}

	/**
	 * ソート順を設定します。<br>
	 * @param orderNo ソート順
	 */
	public final void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}

	/**
	 * 名称を取得します。<br>
	 * @return 名称
	 */
	public final String getCaption() {
		return caption;
	}

	/**
	 * 名称を設定します。<br>
	 * @param caption 名称
	 */
	public final void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 略称を取得します。<br>
	 * @return 略称
	 */
	public final String getShortCaption() {
		return shortCaption;
	}

	/**
	 * 略称を設定します。<br>
	 * @param shortCaption 略称
	 */
	public final void setShortCaption(String shortCaption) {
		this.shortCaption = shortCaption;
	}

	/**
	 * 定義値1を取得します。<br>
	 * @return 定義値1
	 */
	public final String getDefinition1() {
		return definition1;
	}

	/**
	 * 定義値1を設定します。<br>
	 * @param definition1 定義値1
	 */
	public final void setDefinition1(String definition1) {
		this.definition1 = definition1;
	}

	/**
	 * 定義値2を取得します。<br>
	 * @return 定義値2
	 */
	public final String getDefinition2() {
		return definition2;
	}

	/**
	 * 定義値2を設定します。<br>
	 * @param definition2 定義値2
	 */
	public final void setDefinition2(String definition2) {
		this.definition2 = definition2;
	}

	/**
	 * 定義値3を取得します。<br>
	 * @return 定義値3
	 */
	public final String getDefinition3() {
		return definition3;
	}

	/**
	 * 定義値3を設定します。<br>
	 * @param definition3 定義値3
	 */
	public final void setDefinition3(String definition3) {
		this.definition3 = definition3;
	}

	/**
	 * 定義値4を取得します。<br>
	 * @return 定義値4
	 */
	public final String getDefinition4() {
		return definition4;
	}

	/**
	 * 定義値4を設定します。<br>
	 * @param definition4 定義値4
	 */
	public final void setDefinition4(String definition4) {
		this.definition4 = definition4;
	}

	/**
	 * 定義値5を取得します。<br>
	 * @return 定義値5
	 */
	public final String getDefinition5() {
		return definition5;
	}

	/**
	 * 定義値5を設定します。<br>
	 * @param definition5 定義値5
	 */
	public final void setDefinition5(String definition5) {
		this.definition5 = definition5;
	}

	/**
	 * 定義値6を取得します。<br>
	 * @return 定義値6
	 */
	public final String getDefinition6() {
		return definition6;
	}

	/**
	 * 定義値6を設定します。<br>
	 * @param definition6 定義値6
	 */
	public final void setDefinition6(String definition6) {
		this.definition6 = definition6;
	}

	/**
	 * 定義値7を取得します。<br>
	 * @return 定義値7
	 */
	public final String getDefinition7() {
		return definition7;
	}

	/**
	 * 定義値7を設定します。<br>
	 * @param definition7 定義値7
	 */
	public final void setDefinition7(String definition7) {
		this.definition7 = definition7;
	}

	/**
	 * 定義値8を取得します。<br>
	 * @return 定義値8
	 */
	public final String getDefinition8() {
		return definition8;
	}

	/**
	 * 定義値8を設定します。<br>
	 * @param definition8 定義値8
	 */
	public final void setDefinition8(String definition8) {
		this.definition8 = definition8;
	}

	/**
	 * 定義値9を取得します。<br>
	 * @return 定義値9
	 */
	public final String getDefinition9() {
		return definition9;
	}

	/**
	 * 定義値9を設定します。<br>
	 * @param definition9 定義値9
	 */
	public final void setDefinition9(String definition9) {
		this.definition9 = definition9;
	}
}
