package org.phosphoresce.webcore.ext.hibernate4;

import org.phosphoresce.webcore.core.ConfigName;

/**
 * Hibernateアドオン環境設定定義名定数インタフェース<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public class HibernateConfigName extends ConfigName {

	/** Hibernate接続名前空間定義 */
	public static final HibernateConfigName HIBERNATE_NAMESPACES = new HibernateConfigName("hibernate.namespaces");

	/** Hibernate環境設定リソースパス定義 */
	public static final HibernateConfigName HIBERNATE_CONFIG = new HibernateConfigName("hibernate.config");

	/** Hibernateアノテーションモデル定義 */
	public static final HibernateConfigName HIBERNATE_ANNOTATION_CLASSES = new HibernateConfigName("hibernate.annotation.classes");

	/**
	 * コンストラクタ<br>
	 * @param key プロパティキー
	 */
	protected HibernateConfigName(String key) {
		super(key);
	}
}
