package org.phosphoresce.webcore.ext.dynapage.test;

import org.phosphoresce.webcore.ext.dynapage.model.container.ButtonContainer;
import org.phosphoresce.webcore.ext.dynapage.model.container.FieldLineContainer;
import org.phosphoresce.webcore.ext.dynapage.model.container.FieldSetContainer;
import org.phosphoresce.webcore.ext.dynapage.model.container.GeneralContainer;
import org.phosphoresce.webcore.ext.dynapage.model.container.LabeledFieldContainer;
import org.phosphoresce.webcore.ext.dynapage.model.element.ButtonElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.CheckboxElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.DropdownElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.FileElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.ListElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.OptionElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.PasswordElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.RadioElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.TextElement;
import org.phosphoresce.webcore.ext.dynapage.model.element.TextareaElement;
import org.phosphoresce.webcore.ext.dynapage.model.source.NormalPageSource;

/**
 * テストモデルファクトリクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/19	Kitagawa		新規作成
 *-->
 */
public class TestModelFactory {

	/**
	 * コンストラクタ<br>
	 */
	public TestModelFactory() {
		super();
	}

	/**
	 * テストモデルを生成します。<br>
	 * @return テストモデルオブジェクト
	 */
	public NormalPageSource createNormalPage() {
		NormalPageSource normalPage = new NormalPageSource();
		normalPage.addModel(createFieldSetContainer(null, false, false));
		normalPage.addModel(createFieldSetContainer("読取専用", true, false));
		normalPage.addModel(createFieldSetContainer("編集不可", false, true));
		return normalPage;
	}

	/**
	 * フィールドセットコンテナクラスを生成します。<br>
	 * @param label フィールドセットラベル
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public FieldSetContainer createFieldSetContainer(String label, boolean readonly, boolean disabled) {
		FieldSetContainer fieldSetContainer = new FieldSetContainer();
		fieldSetContainer.setLabel(label);
		fieldSetContainer.addModel(createGeneralContainer(readonly, disabled));
		return fieldSetContainer;
	}

	/**
	 * 汎用的なコンテナクラスを生成します。<br>
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public GeneralContainer createGeneralContainer(boolean readonly, boolean disabled) {
		GeneralContainer generalContainer = new GeneralContainer();
		{
			FieldLineContainer container = new FieldLineContainer();
			container.addModel(createTextElement("テキスト", "testText", "testText", "testText", 20, readonly, disabled));
			container.addModel(createPasswordElement("パスワード", "testPassword", "testPassword", "testPassword", 20, readonly, disabled));
			container.addModel(createDropdownElement("ドロップダウン", "testDropdown", "testDropdown", readonly, false));
			generalContainer.addModel(container);
		}
		{
			FieldLineContainer container = new FieldLineContainer();
			container.addModel(createCheckboxElement("チェックボックス", "testCheckbox", "testCheckbox", readonly, disabled));
			generalContainer.addModel(container);
		}
		{
			FieldLineContainer container = new FieldLineContainer();
			container.addModel(createRadioElement("ラジオボタン", "testRadio", "testRadio", readonly, disabled));
			generalContainer.addModel(container);
		}
		{
			FieldLineContainer container = new FieldLineContainer();
			container.addModel(createTextareaElement("テキストエリア", "testTextarea", "testTextarea", "testTextarea", 30, readonly, disabled));
			generalContainer.addModel(container);
		}
		{
			FieldLineContainer container = new FieldLineContainer();
			container.addModel(createListElement("リスト", "testList", "testList", readonly, disabled));
			generalContainer.addModel(container);
		}
		{
			FieldLineContainer container = new FieldLineContainer();
			container.addModel(createFileElement("ファイル", "testFile", "testFile", "testFile", readonly, disabled));
			generalContainer.addModel(container);
		}
		{
			ButtonContainer container = createButtonElement("ボタン", "testButton", "testButton", readonly, disabled);
			generalContainer.addModel(container);
		}
		return generalContainer;
	}

	/**
	 * テキストエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param value エレメント値
	 * @param maxlength 最大文字数
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public LabeledFieldContainer createTextElement(String fieldName, String id, String name, String value, int maxlength, boolean readonly, boolean disabled) {
		LabeledFieldContainer container = new LabeledFieldContainer();
		container.setLabel(fieldName);

		TextElement element = new TextElement();
		element.setId(id);
		element.setName(name);
		element.setValue(value);
		element.setMaxlength(maxlength);
		element.setReadonly(readonly);
		element.setDisabled(disabled);

		container.addModel(element);

		return container;
	}

	/**
	 * パスワードエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param value エレメント値
	 * @param maxlength 最大文字数
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public LabeledFieldContainer createPasswordElement(String fieldName, String id, String name, String value, int maxlength, boolean readonly, boolean disabled) {
		LabeledFieldContainer container = new LabeledFieldContainer();
		container.setLabel(fieldName);

		PasswordElement element = new PasswordElement();
		element.setId(id);
		element.setName(name);
		element.setValue(value);
		element.setMaxlength(maxlength);
		element.setReadonly(readonly);
		element.setDisabled(disabled);

		container.addModel(element);

		return container;
	}

	/**
	 * ドロップダウンエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public LabeledFieldContainer createDropdownElement(String fieldName, String id, String name, boolean readonly, boolean disabled) {
		LabeledFieldContainer container = new LabeledFieldContainer();
		container.setLabel(fieldName);

		DropdownElement element = new DropdownElement();
		element.setId(id);
		element.setName(name);
		element.setDisabled(disabled);

		for (int i = 1; i <= 4; i++) {
			OptionElement option = new OptionElement();
			option.setId(id + "_" + i);
			option.setLabel("オプション" + i);
			option.setValue(String.valueOf(i));
			element.addOption(option);
		}

		container.addModel(element);

		return container;
	}

	/**
	 * リストエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public LabeledFieldContainer createListElement(String fieldName, String id, String name, boolean readonly, boolean disabled) {
		LabeledFieldContainer container = new LabeledFieldContainer();
		container.setLabel(fieldName);

		ListElement element = new ListElement();
		element.setId(id);
		element.setName(name);
		element.setDisabled(disabled);
		element.setSize(3);

		for (int i = 1; i <= 4; i++) {
			OptionElement option = new OptionElement();
			option.setId(id + "_" + i);
			option.setLabel("オプション" + i);
			option.setValue(String.valueOf(i));
			element.addOption(option);
		}

		container.addModel(element);

		return container;
	}

	/**
	 * チェックボックスエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public LabeledFieldContainer createCheckboxElement(String fieldName, String id, String name, boolean readonly, boolean disabled) {
		LabeledFieldContainer container = new LabeledFieldContainer();
		container.setLabel(fieldName);

		for (int i = 1; i <= 4; i++) {
			CheckboxElement element = new CheckboxElement();
			element.setId(id + "_" + i);
			element.setName(name + "_" + i);
			element.setReadonly(readonly);
			element.setDisabled(disabled);
			element.setLabel("チェックボックス" + i);
			element.setValue(String.valueOf(i));
			container.addModel(element);
		}

		return container;
	}

	/**
	 * ラジオボタンエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public LabeledFieldContainer createRadioElement(String fieldName, String id, String name, boolean readonly, boolean disabled) {
		LabeledFieldContainer container = new LabeledFieldContainer();
		container.setLabel(fieldName);

		for (int i = 1; i <= 4; i++) {
			RadioElement element = new RadioElement();
			element.setId(id + "_" + i);
			element.setName(name + "_" + i);
			element.setReadonly(readonly);
			element.setDisabled(disabled);
			element.setLabel("ラジオボタン" + i);
			element.setValue(String.valueOf(i));
			container.addModel(element);
		}

		return container;
	}

	/**
	 * テキストエリアエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public LabeledFieldContainer createTextareaElement(String fieldName, String id, String name, String value, int maxlength, boolean readonly, boolean disabled) {
		LabeledFieldContainer container = new LabeledFieldContainer();
		container.setLabel(fieldName);

		TextareaElement element = new TextareaElement();
		element.setId(id);
		element.setName(name);
		element.setValue(value);
		element.setMaxlength(maxlength);
		element.setReadonly(readonly);
		element.setDisabled(disabled);

		container.addModel(element);

		return container;
	}

	/**
	 * ファイルエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public LabeledFieldContainer createFileElement(String fieldName, String id, String name, String value, boolean readonly, boolean disabled) {
		LabeledFieldContainer container = new LabeledFieldContainer();
		container.setLabel(fieldName);

		FileElement element = new FileElement();
		element.setId(id);
		element.setName(name);
		element.setReadonly(readonly);
		element.setDisabled(disabled);

		container.addModel(element);

		return container;
	}

	/**
	 * ボタンエレメントのラベル付きフィールドを生成します。<br>
	 * @param fieldName フィールド名
	 * @param id エレメントID
	 * @param name エレメント名
	 * @param readonly 読み込み専用フラグ
	 * @param disabled 編集不可フラグ
	 * @return モデルインスタンス
	 */
	public ButtonContainer createButtonElement(String fieldName, String id, String name, boolean readonly, boolean disabled) {
		ButtonContainer container = new ButtonContainer();

		for (int i = 1; i <= 3; i++) {
			ButtonElement element = new ButtonElement();
			element.setId(id + "_" + i);
			element.setName(name + "_" + i);
			element.setReadonly(readonly);
			element.setDisabled(disabled);
			element.setValue("ボタン" + i);
			container.addModel(element);
		}

		return container;
	}
}
