package org.phosphoresce.webcore.ext.dynapage.model.element;

import org.phosphoresce.webcore.ext.dynapage.model.FieldModel;

/**
 * リストエレメント定義モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
@FieldModel(template = "/org/phosphoresce/webcore/ext/dynapage/template/element/ListElement.vm")
public class ListElement extends AbstractListElement {

	/** リストサイズ */
	private Integer size = null;

	/** 複数選択フラグ */
	private boolean mutiple = false;

	/**
	 * コンストラクタ<br>
	 */
	public ListElement() {
		super();
	}

	/**
	 * リストサイズを取得します。<br>
	 * @return リストサイズ
	 */
	public Integer getSize() {
		return size;
	}

	/**
	 * リストサイズを設定します。<br>
	 * @param size リストサイズ
	 */
	public void setSize(int size) {
		this.size = size;
	}

	/**
	 * 複数選択フラグを取得します。<br>
	 * @return 複数選択フラグ
	 */
	public boolean isMutiple() {
		return mutiple;
	}

	/**
	 * 複数選択フラグを設定します。<br>
	 * @param mutiple 複数選択フラグ
	 */
	public void setMutiple(boolean mutiple) {
		this.mutiple = mutiple;
	}
}
