package org.phosphoresce.webcore.ext.dynapage.model.element;

import org.phosphoresce.webcore.ext.dynapage.model.AbstractModel;
import org.phosphoresce.webcore.ext.dynapage.model.FieldModel;

/**
 * 隠し項目エレメント定義モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
@FieldModel(template = "/org/phosphoresce/webcore/ext/dynapage/template/element/HiddenElement.vm")
public class HiddenElement extends AbstractModel {

	/** エレメント名 */
	private String name;

	/** エレメント値 */
	private String value;

	/**
	 * コンストラクタ<br>
	 */
	public HiddenElement() {
		super();
	}

	/**
	 * エレメント名を取得します。<br>
	 * @return エレメント名
	 */
	public final String getName() {
		return name;
	}

	/**
	 * エレメント名を設定します。<br>
	 * @param name エレメント名
	 */
	public final void setName(String name) {
		this.name = name;
	}

	/**
	 * エレメント値を取得します。<br>
	 * @return エレメント値
	 */
	public final String getValue() {
		return value;
	}

	/**
	 * エレメント値を設定します。<br>
	 * @param value エレメント値
	 */
	public final void setValue(String value) {
		this.value = value;
	}
}
