package org.phosphoresce.webcore.ext.dynapage.model.element;

import org.phosphoresce.webcore.ext.dynapage.model.AbstractModel;
import org.phosphoresce.webcore.ext.dynapage.model.FieldModel;

/**
 * ファイルエレメント定義モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
@FieldModel(template = "/org/phosphoresce/webcore/ext/dynapage/template/element/FileElement.vm")
public class FileElement extends AbstractModel {

	/** エレメント名 */
	private String name;

	/** 読み込み専用フラグ */
	private boolean readonly;

	/** 編集不可フラグ */
	private boolean disabled;

	/**
	 * コンストラクタ<br>
	 */
	public FileElement() {
		super();
	}

	/**
	 * エレメント名を取得します。<br>
	 * @return エレメント名
	 */
	public final String getName() {
		return name;
	}

	/**
	 * エレメント名を設定します。<br>
	 * @param name エレメント名
	 */
	public final void setName(String name) {
		this.name = name;
	}

	/**
	 * 読み込み専用フラグを取得します。<br>
	 * @return 読み込み専用フラグ
	 */
	public final boolean isReadonly() {
		return readonly;
	}

	/**
	 * 読み込み専用フラグを設定します。<br>
	 * @param readonly 読み込み専用フラグ
	 */
	public final void setReadonly(boolean readonly) {
		this.readonly = readonly;
	}

	/**
	 * 編集不可フラグを取得します。<br>
	 * @return 編集不可フラグ
	 */
	public final boolean isDisabled() {
		return disabled;
	}

	/**
	 * 編集不可フラグを設定します。<br>
	 * @param disabled 編集不可フラグ
	 */
	public final void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}
}
