package org.phosphoresce.webcore.ext.dynapage.model;

import java.io.Serializable;

import org.phosphoresce.lib.commons.util.AnnotationUtil;
import org.phosphoresce.webcore.ext.dynapage.DynapageConstants;

/**
 * フィールド定義上位抽象モデルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/18	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractModel implements Serializable, DynapageConstants {

	/** フィールドID */
	private String id;

	/** クラス識別 */
	private String className;

	/**
	 * コンストラクタ<br>
	 */
	public AbstractModel() {
		super();
	}

	/**
	 * フィールドテンプレートパスを取得します。<br>
	 * @return フィールドテンプレートパス
	 */
	public final String getTemplate() {
		FieldModel modelType = AnnotationUtil.getClassAnnotation(FieldModel.class, getClass());
		if (modelType == null) {
			return "";
		} else {
			return modelType.template();
		}
	}

	/**
	 * フィールドIDを取得します。<br>
	 * @return フィールドID
	 */
	public final String getId() {
		return id;
	}

	/**
	 * フィールドIDを設定します。<br>
	 * @param id フィールドID
	 */
	public final void setId(String id) {
		this.id = id;
	}

	/**
	 * クラス識別を取得します。<br>
	 * @return クラス識別
	 */
	public final String getClassName() {
		return className;
	}

	/**
	 * クラス識別を設定します。<br>
	 * @param className クラス識別
	 */
	public final void setClassName(String className) {
		this.className = className;
	}
}
